/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.weapon;

import liedge.ltxindustries.entity.GlowstickProjectileEntity;
import liedge.ltxindustries.item.weapon.SemiAutoWeaponItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class GlowstickLauncherItem
extends SemiAutoWeaponItem {
    public GlowstickLauncherItem(Item.Properties properties) {
        super(properties, 10, 3.9, 10, (Holder<Item>)LTXIItems.LIGHTWEIGHT_WEAPON_ENERGY, 1, 0.0);
    }

    @Override
    @Nullable
    public ResourceKey<EquipmentUpgrade> getDefaultUpgradeKey() {
        return LTXIEquipmentUpgrades.GLOWSTICK_LAUNCHER_DEFAULT;
    }

    @Override
    public boolean isOneHanded(ItemStack stack) {
        return true;
    }

    @Override
    public boolean canFocusReticle(ItemStack heldItem, Player player, AbstractWeaponControls controls) {
        return false;
    }

    @Override
    public void weaponFired(ItemStack heldItem, Player player, Level level, AbstractWeaponControls controls) {
        if (!level.isClientSide()) {
            GlowstickProjectileEntity glowstick = new GlowstickProjectileEntity(level);
            glowstick.setOwner((LivingEntity)player);
            glowstick.aimAndSetPosFromShooter((LivingEntity)player, this.getProjectileWeaponRange(heldItem), 0.0);
            level.addFreshEntity((Entity)glowstick);
            level.gameEvent((Entity)player, LTXIGameEvents.WEAPON_FIRED, player.getEyePosition());
        }
        level.playSound(player, (Entity)player, (SoundEvent)LTXISounds.GLOWSTICK_LAUNCHER_FIRE.get(), SoundSource.PLAYERS, 2.0f, 1.0f + level.random.nextFloat() * 0.15f);
    }

    @Override
    public int getFireRate(ItemStack stack) {
        return 10;
    }
}

