/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.weapon;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.lib.OrderedEnum;
import liedge.limacore.lib.Translatable;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.entity.OrbGrenadeEntity;
import liedge.ltxindustries.item.ScrollModeSwitchItem;
import liedge.ltxindustries.item.weapon.SemiAutoWeaponItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;

public class GrenadeLauncherItem
extends SemiAutoWeaponItem
implements ScrollModeSwitchItem {
    public static final Translatable GRENADE_TYPE_TOOLTIP = LTXILangKeys.tooltip("equipped_grenade");

    public static GrenadeType getGrenadeTypeFromItem(ItemStack stack) {
        return (GrenadeType)stack.getOrDefault(LTXIDataComponents.GRENADE_TYPE, (Object)GrenadeType.EXPLOSIVE);
    }

    public GrenadeLauncherItem(Item.Properties properties) {
        super(properties, 6, 1.5, 50, (Holder<Item>)LTXIItems.EXPLOSIVES_WEAPON_ENERGY, 1, 0.0);
    }

    public void setGrenadeType(ItemStack stack, GrenadeType grenadeType) {
        stack.set(LTXIDataComponents.GRENADE_TYPE, (Object)grenadeType);
    }

    public ItemStack createDecorativeStack(GrenadeType grenadeType) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setAmmoLoadedMax(stack);
        this.setGrenadeType(stack, grenadeType);
        return stack;
    }

    @Override
    public boolean canFocusReticle(ItemStack heldItem, Player player, AbstractWeaponControls controls) {
        return false;
    }

    @Override
    public void onUpgradeRefresh(LootContext context, ItemStack stack, EquipmentUpgrades upgrades) {
        super.onUpgradeRefresh(context, stack, upgrades);
        GrenadeType currentlyEquipped = GrenadeLauncherItem.getGrenadeTypeFromItem(stack);
        boolean shouldReset = upgrades.effectFlatStream((DataComponentType)LTXIUpgradeEffectComponents.GRENADE_UNLOCK.get()).noneMatch(currentlyEquipped::equals);
        if (shouldReset) {
            this.setGrenadeType(stack, GrenadeType.EXPLOSIVE);
        }
    }

    @Override
    public void weaponFired(ItemStack heldItem, Player player, Level level, AbstractWeaponControls controls) {
        if (!level.isClientSide()) {
            OrbGrenadeEntity grenade = new OrbGrenadeEntity(level, GrenadeLauncherItem.getGrenadeTypeFromItem(heldItem), heldItem);
            grenade.setOwner((LivingEntity)player);
            grenade.aimAndSetPosFromShooter((LivingEntity)player, this.getProjectileWeaponRange(heldItem), 0.0);
            level.addFreshEntity((Entity)grenade);
            level.gameEvent((Entity)player, LTXIGameEvents.WEAPON_FIRED, player.getEyePosition());
        }
        level.playSound(player, (Entity)player, (SoundEvent)LTXISounds.GRENADE_LAUNCHER_FIRE.get(), SoundSource.PLAYERS, 2.0f, Mth.randomBetween((RandomSource)level.random, (float)0.9f, (float)1.1f));
    }

    @Override
    public int getFireRate(ItemStack stack) {
        return 15;
    }

    @Override
    public void switchItemMode(ItemStack stack, Player player, int delta) {
        GrenadeType toSwitch;
        boolean forward = delta == 1;
        EquipmentUpgrades upgrades = this.getUpgrades(stack);
        ObjectOpenHashSet availableTypes = new ObjectOpenHashSet();
        availableTypes.add(GrenadeType.EXPLOSIVE);
        upgrades.forEachEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, (arg_0, arg_1) -> GrenadeLauncherItem.lambda$switchItemMode$0((Set)availableTypes, arg_0, arg_1));
        GrenadeType currentType = GrenadeLauncherItem.getGrenadeTypeFromItem(stack);
        GrenadeType grenadeType = toSwitch = forward ? (GrenadeType)OrderedEnum.nextAvailable((Set)availableTypes, (Enum)currentType) : (GrenadeType)OrderedEnum.previousAvailable((Set)availableTypes, (Enum)currentType);
        if (!currentType.equals(toSwitch)) {
            this.setGrenadeType(stack, toSwitch);
            player.level().playSound(null, (Entity)player, (SoundEvent)LTXISounds.WEAPON_MODE_SWITCH.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void addAdditionalToCreativeTab(ResourceLocation tabId, CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, CreativeModeTab.TabVisibility tabVisibility) {
        HolderLookup.Provider registries = parameters.holders();
        ItemStack stack = new ItemStack((ItemLike)this);
        this.setUpgrades(stack, EquipmentUpgrades.builder().set((Holder<EquipmentUpgrade>)registries.holderOrThrow(LTXIEquipmentUpgrades.OMNI_GRENADE_CORE)).toImmutable());
        this.setAmmoLoadedMax(stack);
        output.accept(stack, tabVisibility);
    }

    @Override
    public void appendTooltipHintComponents(Level level, ItemStack stack, TooltipLineConsumer consumer) {
        consumer.accept((FormattedText)GRENADE_TYPE_TOOLTIP.translateArgs(new Object[]{GrenadeLauncherItem.getGrenadeTypeFromItem(stack).translate()}));
        super.appendTooltipHintComponents(level, stack, consumer);
    }

    private static /* synthetic */ void lambda$switchItemMode$0(Set availableTypes, GrenadeType effect, int rank) {
        availableTypes.add(effect);
    }
}

