/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.weapon;

import java.util.Comparator;
import java.util.Optional;
import liedge.ltxindustries.entity.EquipmentRocketEntity;
import liedge.ltxindustries.entity.LTXIEntityUtil;
import liedge.ltxindustries.item.weapon.SemiAutoWeaponItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RocketLauncherItem
extends SemiAutoWeaponItem {
    public RocketLauncherItem(Item.Properties properties) {
        super(properties, 2, 1.5, 60, (Holder<Item>)LTXIItems.EXPLOSIVES_WEAPON_ENERGY, 1, 0.0);
    }

    private boolean isInTargetScanPath(Player player, Entity target, EquipmentUpgrades upgrades) {
        if (LTXIEntityUtil.checkWeaponTargetValidity((Entity)player, target, upgrades) && target.distanceTo((Entity)player) >= 10.0f && target instanceof LivingEntity) {
            Vec3 look = player.getViewVector(1.0f);
            Vec3 path = target.getBoundingBox().getCenter().subtract(player.getEyePosition());
            double distanceBetween = path.length();
            double dot = look.dot(path.normalize());
            return dot > 1.0 - target.getBoundingBox().getSize() / 16.0 / distanceBetween;
        }
        return false;
    }

    @Override
    public boolean canFocusReticle(ItemStack heldItem, Player player, AbstractWeaponControls controls) {
        boolean canTryFocus = super.canFocusReticle(heldItem, player, controls);
        Level level = player.level();
        if (!level.isClientSide() && canTryFocus) {
            Entity entity;
            Vec3 scanPath = player.getViewVector(1.0f).scale(60.0);
            EquipmentUpgrades upgrades = this.getUpgrades(heldItem);
            Optional<Entity> entity2 = level.getEntities((Entity)player, player.getBoundingBox().expandTowards(scanPath), e -> this.isInTargetScanPath(player, (Entity)e, upgrades)).stream().min(Comparator.comparingDouble(e -> e.distanceToSqr((Entity)player))).filter(e -> {
                BlockHitResult blockTrace = level.clip(new ClipContext(player.getEyePosition(), e.getBoundingBox().getCenter(), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                return blockTrace.getType() == HitResult.Type.MISS || e.getBoundingBox().contains(blockTrace.getLocation());
            });
            if (entity2.isPresent() && (entity = entity2.get()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (!player.level().isClientSide()) {
                    controls.asServerControls().setFocusedTargetAndNotify(player, livingEntity);
                }
                return true;
            }
        }
        return false;
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        livingEntity.getExistingData(LTXIAttachmentTypes.WEAPON_CONTROLS).ifPresent(controls -> {
            if (controls.getFocusedTarget() != null && !LTXIEntityUtil.isEntityAlive((Entity)controls.getFocusedTarget())) {
                livingEntity.stopUsingItem();
            }
        });
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide()) {
            ((AbstractWeaponControls)player.getData(LTXIAttachmentTypes.WEAPON_CONTROLS)).asServerControls().setFocusedTargetAndNotify(player, null);
        }
    }

    @Override
    public void weaponFired(ItemStack heldItem, Player player, Level level, AbstractWeaponControls controls) {
        if (!level.isClientSide()) {
            EquipmentRocketEntity rocket = new EquipmentRocketEntity(level, heldItem);
            rocket.setOwner((LivingEntity)player);
            LivingEntity focusedTarget = controls.getFocusedTarget();
            rocket.aimAndSetPosFromShooter((LivingEntity)player, this.getProjectileWeaponRange(heldItem), 0.0);
            if (focusedTarget != null && controls.getTargetTicks() > 20) {
                rocket.setTargetEntity((Entity)focusedTarget);
            }
            level.addFreshEntity((Entity)rocket);
            level.gameEvent((Entity)player, LTXIGameEvents.WEAPON_FIRED, player.getEyePosition());
        }
        level.playSound(player, (Entity)player, (SoundEvent)LTXISounds.ROCKET_LAUNCHER_FIRE.get(), SoundSource.PLAYERS, 2.0f, Mth.randomBetween((RandomSource)level.random, (float)0.75f, (float)0.9f));
    }

    @Override
    public int getFireRate(ItemStack stack) {
        return 30;
    }
}

