/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.weapon;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import liedge.ltxindustries.entity.CompoundHitResult;
import liedge.ltxindustries.entity.DynamicClipContext;
import liedge.ltxindustries.item.weapon.SemiAutoWeaponItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.registry.bootstrap.LTXIEquipmentUpgrades;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXISounds;
import liedge.ltxindustries.util.config.LTXIWeaponsConfig;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;

public class ShotgunItem
extends SemiAutoWeaponItem {
    public ShotgunItem(Item.Properties properties) {
        super(properties, 5, 10.0, 40, (Holder<Item>)LTXIItems.SPECIALIST_WEAPON_ENERGY, 5, 0.33);
    }

    @Override
    @Nullable
    public ResourceKey<EquipmentUpgrade> getDefaultUpgradeKey() {
        return LTXIEquipmentUpgrades.SHOTGUN_DEFAULT;
    }

    @Override
    public boolean canFocusReticle(ItemStack heldItem, Player player, AbstractWeaponControls controls) {
        return false;
    }

    @Override
    public void weaponFired(ItemStack heldItem, Player player, Level level, AbstractWeaponControls controls) {
        if (!level.isClientSide()) {
            Object2IntOpenHashMap pelletHits = new Object2IntOpenHashMap();
            for (int i = 0; i < 7; ++i) {
                CompoundHitResult hitResult = CompoundHitResult.tracePath(level, (LivingEntity)player, this.getUpgrades(heldItem), this.getWeaponRange(heldItem), 6.5, this.getEntityMaxHits(heldItem), this.getBlockPierceDistance(heldItem), DynamicClipContext.FluidCollisionPredicate.NONE, hit -> hit.getBoundingBox().getSize() <= 1.0 ? 0.75 : 0.375);
                hitResult.entityHits().forEach(arg_0 -> ShotgunItem.lambda$weaponFired$1((Object2IntMap)pelletHits, arg_0));
                this.sendTracerParticle(level, hitResult.origin(), hitResult.impactLocation());
            }
            double basePelletDamage = LTXIWeaponsConfig.SHOTGUN_BASE_PELLET_DAMAGE.getAsDouble();
            pelletHits.forEach((hitEntity, pellets) -> this.causeLightfragDamage(heldItem, (LivingEntity)player, (Entity)hitEntity, basePelletDamage * (double)pellets.intValue()));
            level.gameEvent((Entity)player, LTXIGameEvents.WEAPON_FIRED, player.getEyePosition());
        }
        level.playSound(player, (Entity)player, (SoundEvent)LTXISounds.SHOTGUN_FIRE.get(), SoundSource.PLAYERS, 2.0f, Mth.randomBetween((RandomSource)player.getRandom(), (float)0.9f, (float)1.0f));
    }

    @Override
    public int getFireRate(ItemStack stack) {
        return 10;
    }

    private static /* synthetic */ void lambda$weaponFired$1(Object2IntMap pelletHits, EntityHitResult hit) {
        pelletHits.mergeInt((Object)hit.getEntity(), 1, Integer::sum);
    }
}

