/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.item.weapon;

import com.mojang.serialization.Codec;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import liedge.limacore.client.gui.TooltipLineConsumer;
import liedge.limacore.client.particle.ColorParticleOptions;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.item.LimaCreativeTabFillerItem;
import liedge.limacore.lib.TickTimer;
import liedge.limacore.lib.Translatable;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.util.LimaLootUtil;
import liedge.limacore.util.LimaNetworkUtil;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.entity.CompoundHitResult;
import liedge.ltxindustries.entity.DynamicClipContext;
import liedge.ltxindustries.entity.LimaTraceableEntity;
import liedge.ltxindustries.entity.damage.UpgradableEquipmentDamageSource;
import liedge.ltxindustries.item.EnergyHolderItem;
import liedge.ltxindustries.item.TooltipShiftHintItem;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.EquipmentDamageModifiers;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.lib.weapons.WeaponReloadSource;
import liedge.ltxindustries.registry.bootstrap.LTXIDamageTypes;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIGameEvents;
import liedge.ltxindustries.registry.game.LTXIParticles;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;
import org.jetbrains.annotations.Nullable;

public abstract class WeaponItem
extends Item
implements EnergyHolderItem,
LimaCreativeTabFillerItem,
TooltipShiftHintItem,
UpgradableEquipmentItem {
    public static final Codec<WeaponItem> CODEC = LimaCoreCodecs.classCastRegistryCodec((Registry)BuiltInRegistries.ITEM, WeaponItem.class);
    public static final StreamCodec<RegistryFriendlyByteBuf, WeaponItem> STREAM_CODEC = LimaStreamCodecs.classCastRegistryStreamCodec((ResourceKey)Registries.ITEM, WeaponItem.class);
    public static final Translatable AMMO_LOADED_TOOLTIP = LTXILangKeys.tooltip("ammo_loaded");
    public static final Translatable RELOAD_SPEED_TOOLTIP = LTXILangKeys.tooltip("reload_speed");
    public static final double MAX_PROJECTILE_SPEED = 3.9;
    private final int baseMagCapacity;
    private final double baseRange;
    private final int baseReloadSpeed;
    private final WeaponReloadSource baseReloadSource;
    private final int baseMaxHits;
    private final double basePunchTrough;

    protected WeaponItem(Item.Properties properties, int baseMagCapacity, double baseRange, int baseReloadSpeed, WeaponReloadSource baseReloadSource, int baseMaxHits, double basePunchThrough) {
        super(properties.component(LTXIDataComponents.MAGAZINE_CAPACITY, (Object)baseMagCapacity).component(LTXIDataComponents.WEAPON_RANGE, (Object)baseRange).component(LTXIDataComponents.RELOAD_SPEED, (Object)baseReloadSpeed).component(LTXIDataComponents.RELOAD_SOURCE, (Object)baseReloadSource).component(LTXIDataComponents.MAX_HITS, (Object)baseMaxHits).component(LTXIDataComponents.PUNCH_THROUGH, (Object)basePunchThrough));
        this.baseMagCapacity = baseMagCapacity;
        this.baseRange = baseRange;
        this.baseReloadSpeed = baseReloadSpeed;
        this.baseReloadSource = baseReloadSource;
        this.baseMaxHits = baseMaxHits;
        this.basePunchTrough = basePunchThrough;
    }

    protected WeaponItem(Item.Properties properties, int baseMagCapacity, double baseRange, int baseReloadSpeed, Holder<Item> defaultAmmoItem, int baseMaxHits, double basePunchTrough) {
        this(properties, baseMagCapacity, baseRange, baseReloadSpeed, WeaponReloadSource.withItem(defaultAmmoItem), baseMaxHits, basePunchTrough);
    }

    public abstract void triggerPressed(ItemStack var1, Player var2, AbstractWeaponControls var3);

    public abstract boolean canContinueHoldingTrigger(ItemStack var1, Player var2, AbstractWeaponControls var3);

    public void triggerHoldingTick(ItemStack heldItem, Player player, AbstractWeaponControls input) {
    }

    public void onStartedHoldingTrigger(ItemStack heldItem, Player player, AbstractWeaponControls input) {
    }

    public void onStoppedHoldingTrigger(ItemStack heldItem, Player player, AbstractWeaponControls input, boolean releasedByPlayer) {
    }

    public abstract void weaponFired(ItemStack var1, Player var2, Level var3, AbstractWeaponControls var4);

    @Override
    public boolean supportsEnergyStorage(ItemStack stack) {
        return this.getReloadSource(stack).getType() == WeaponReloadSource.Type.COMMON_ENERGY;
    }

    @Override
    public final int getBaseEnergyCapacity(ItemStack stack) {
        return 1;
    }

    @Override
    public final int getBaseEnergyUsage(ItemStack stack) {
        return 1;
    }

    @Override
    public final int getBaseEnergyTransferRate(ItemStack stack) {
        return this.getEnergyCapacity(stack) / 20;
    }

    public boolean canFocusReticle(ItemStack heldItem, Player player, AbstractWeaponControls controls) {
        return controls.getReloadTimer().getTimerState() == TickTimer.State.STOPPED;
    }

    public int getAmmoLoaded(ItemStack stack) {
        return (Integer)stack.getOrDefault(LTXIDataComponents.WEAPON_AMMO, (Object)0);
    }

    public void setAmmoLoaded(ItemStack stack, int newAmmo) {
        stack.set(LTXIDataComponents.WEAPON_AMMO, (Object)Math.max(0, newAmmo));
    }

    public void setAmmoLoadedMax(ItemStack stack) {
        this.setAmmoLoaded(stack, this.getAmmoCapacity(stack));
    }

    public final int getAmmoCapacity(ItemStack stack) {
        return (Integer)stack.getOrDefault(LTXIDataComponents.MAGAZINE_CAPACITY, (Object)this.baseMagCapacity);
    }

    public boolean isOneHanded(ItemStack stack) {
        return false;
    }

    public abstract int getFireRate(ItemStack var1);

    public double getWeaponRange(ItemStack stack) {
        return (Double)stack.getOrDefault(LTXIDataComponents.WEAPON_RANGE, (Object)this.baseRange);
    }

    public double getProjectileWeaponRange(ItemStack stack) {
        return Mth.clamp((double)this.getWeaponRange(stack), (double)0.0, (double)3.9);
    }

    public int getReloadSpeed(ItemStack stack) {
        return (Integer)stack.getOrDefault(LTXIDataComponents.RELOAD_SPEED, (Object)this.baseReloadSpeed);
    }

    public WeaponReloadSource getReloadSource(ItemStack stack) {
        return (WeaponReloadSource)stack.getOrDefault(LTXIDataComponents.RELOAD_SOURCE, (Object)this.baseReloadSource);
    }

    public int getEntityMaxHits(ItemStack stack) {
        return (Integer)stack.getOrDefault(LTXIDataComponents.MAX_HITS, (Object)this.baseMaxHits);
    }

    public double getBlockPierceDistance(ItemStack stack) {
        return (Double)stack.getOrDefault(LTXIDataComponents.PUNCH_THROUGH, (Object)this.basePunchTrough);
    }

    @Override
    public void onUpgradeRefresh(LootContext context, ItemStack stack, EquipmentUpgrades upgrades) {
        this.applyIntStat(stack, upgrades, context, this.baseMagCapacity, (Supplier<? extends DataComponentType<Integer>>)LTXIDataComponents.MAGAZINE_CAPACITY, (Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.MAGAZINE_CAPACITY);
        this.applyDoubleStat(stack, upgrades, context, this.baseRange, (Supplier<? extends DataComponentType<Double>>)LTXIDataComponents.WEAPON_RANGE, (Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.WEAPON_RANGE);
        this.applyIntStat(stack, upgrades, context, this.baseReloadSpeed, (Supplier<? extends DataComponentType<Integer>>)LTXIDataComponents.RELOAD_SPEED, (Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.RELOAD_SPEED);
        this.applyIntStat(stack, upgrades, context, this.baseMaxHits, (Supplier<? extends DataComponentType<Integer>>)LTXIDataComponents.MAX_HITS, (Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.MAX_HITS);
        this.applyDoubleStat(stack, upgrades, context, this.basePunchTrough, (Supplier<? extends DataComponentType<Double>>)LTXIDataComponents.PUNCH_THROUGH, (Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>>)LTXIUpgradeEffectComponents.BLOCK_PIERCE_DISTANCE);
        WeaponReloadSource reloadSource = upgrades.effectStream(LTXIUpgradeEffectComponents.RELOAD_SOURCE).max(Comparator.comparing(WeaponReloadSource::getType)).orElse(this.baseReloadSource);
        stack.set(LTXIDataComponents.RELOAD_SOURCE, (Object)reloadSource);
        UpgradableEquipmentItem.super.onUpgradeRefresh(context, stack, upgrades);
    }

    private boolean hurtEntity(LivingEntity attacker, Entity target, UpgradableEquipmentDamageSource damageSource, double baseDamage) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LootContext context = LimaLootUtil.entityLootContext((ServerLevel)level2, (Entity)target, (DamageSource)damageSource, (LivingEntity)attacker);
            ItemStack weaponItem = damageSource.getWeaponItem();
            EquipmentUpgrades upgrades = this.getUpgrades(weaponItem);
            upgrades.applyDamageContextEffects((Supplier<? extends DataComponentType<List<TargetedConditionalEffect<EntityUpgradeEffect>>>>)LTXIUpgradeEffectComponents.EQUIPMENT_PRE_ATTACK, level2, EnchantmentTarget.ATTACKER, target, attacker, (DamageSource)damageSource);
            double damage = EquipmentDamageModifiers.getInstance().apply(weaponItem, context, baseDamage, this.getUpgradedDamage(level2, upgrades, target, damageSource, baseDamage));
            return damage > 1.0E-4 && target.hurt((DamageSource)damageSource, (float)damage);
        }
        return false;
    }

    protected void causeLightfragDamage(ItemStack heldItem, LivingEntity attacker, Entity targetEntity, double baseDamage) {
        UpgradableEquipmentDamageSource source = UpgradableEquipmentDamageSource.directDamage(LTXIDamageTypes.LIGHTFRAG, (Entity)attacker, heldItem);
        this.hurtEntity(attacker, targetEntity, source, baseDamage);
    }

    public boolean causeProjectileDamage(ItemStack weaponItem, LimaTraceableEntity projectile, @Nullable LivingEntity attacker, ResourceKey<DamageType> damageTypeKey, Entity targetEntity, double baseDamage) {
        UpgradableEquipmentDamageSource source = UpgradableEquipmentDamageSource.projectileDamage(damageTypeKey, projectile, (Entity)attacker, weaponItem);
        if (attacker != null) {
            return this.hurtEntity(attacker, targetEntity, source, baseDamage);
        }
        return targetEntity.hurt((DamageSource)source, (float)baseDamage);
    }

    protected void traceLightfrag(ItemStack stack, Player player, Level level, double baseDamage, double inaccuracy, double bbExpansion) {
        if (!level.isClientSide()) {
            CompoundHitResult hitResult = CompoundHitResult.tracePath(level, (LivingEntity)player, this.getUpgrades(stack), this.getWeaponRange(stack), inaccuracy, this.getEntityMaxHits(stack), this.getBlockPierceDistance(stack), DynamicClipContext.FluidCollisionPredicate.NONE, bbExpansion);
            hitResult.entityHits().forEach(hit -> this.causeLightfragDamage(stack, (LivingEntity)player, hit.getEntity(), baseDamage));
            level.gameEvent((Entity)player, LTXIGameEvents.WEAPON_FIRED, player.getEyePosition());
            this.sendTracerParticle(level, hitResult.origin(), hitResult.impactLocation());
        }
    }

    protected void sendTracerParticle(Level level, Vec3 start, Vec3 end) {
        LimaNetworkUtil.sendParticle((Level)level, (ParticleOptions)new ColorParticleOptions(LTXIParticles.LIGHTFRAG_TRACER, LTXIConstants.LIME_GREEN), (double)512.0, (Vec3)start, (Vec3)end);
    }

    @Override
    public void appendTooltipHintComponents(Level level, ItemStack stack, TooltipLineConsumer consumer) {
        consumer.accept((FormattedText)AMMO_LOADED_TOOLTIP.translateArgs(new Object[]{Component.literal((String)Integer.toString(this.getAmmoLoaded(stack))).withStyle(LTXIConstants.LIME_GREEN.chatStyle()), this.getAmmoCapacity(stack)}).withStyle(ChatFormatting.GRAY));
        consumer.accept((FormattedText)RELOAD_SPEED_TOOLTIP.translateArgs(new Object[]{LTXITooltipUtil.flatNumberWithoutSign((double)this.getReloadSpeed(stack) / 20.0).withStyle(LTXIConstants.LIME_GREEN.chatStyle())}).withStyle(ChatFormatting.GRAY));
        WeaponReloadSource reloadSource = this.getReloadSource(stack);
        consumer.accept((FormattedText)reloadSource.getItemTooltip());
        if (reloadSource.getType() == WeaponReloadSource.Type.COMMON_ENERGY) {
            this.appendEquipmentEnergyTooltip(consumer, stack);
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (usedHand == InteractionHand.MAIN_HAND) {
            boolean handCheck;
            ItemStack offhandItem = player.getOffhandItem();
            boolean bl = handCheck = offhandItem.isEmpty() || this.isOneHanded(stack);
            if (handCheck && !offhandItem.canPerformAction(ItemAbilities.SHIELD_BLOCK) && this.canFocusReticle(stack, player, (AbstractWeaponControls)player.getData(LTXIAttachmentTypes.WEAPON_CONTROLS))) {
                return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)InteractionHand.MAIN_HAND);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public boolean addDefaultInstanceToCreativeTab(ResourceLocation tabId) {
        return false;
    }

    public void addAdditionalToCreativeTab(ResourceLocation tabId, CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, CreativeModeTab.TabVisibility tabVisibility) {
        ItemStack stack = this.createStackWithDefaultUpgrades(parameters.holders());
        this.setAmmoLoadedMax(stack);
        output.accept(stack, tabVisibility);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean isFoil(ItemStack stack) {
        return false;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    private void applyDoubleStat(ItemStack stack, EquipmentUpgrades upgrades, LootContext context, double baseFallback, Supplier<? extends DataComponentType<Double>> type, Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>> effectType) {
        double base = (Double)this.components().getOrDefault(type.get(), (Object)baseFallback);
        double value = upgrades.applyValue(effectType, context, base);
        stack.set(type, (Object)value);
    }

    private void applyIntStat(ItemStack stack, EquipmentUpgrades upgrades, LootContext context, int baseFallback, Supplier<? extends DataComponentType<Integer>> type, Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>> effectType) {
        int base = (Integer)this.components().getOrDefault(type.get(), (Object)baseFallback);
        int value = LimaCoreMath.round((double)upgrades.applyValue(effectType, context, (double)base));
        stack.set(type, (Object)value);
    }
}

