/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import liedge.limacore.lib.math.MathOperation;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import org.jetbrains.annotations.Nullable;

public record EquipmentDamageModifier(Optional<ItemPredicate> equipmentPredicate, Optional<LootItemCondition> condition, NumberProvider value, MathOperation operation) implements Comparable<EquipmentDamageModifier>,
BiPredicate<ItemStack, LootContext>
{
    public static final Codec<EquipmentDamageModifier> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemPredicate.CODEC.optionalFieldOf("equipment_predicate").forGetter(EquipmentDamageModifier::equipmentPredicate), (App)ConditionalEffect.conditionCodec((LootContextParamSet)LootContextParamSets.ENTITY).optionalFieldOf("condition").forGetter(EquipmentDamageModifier::condition), (App)NumberProviders.CODEC.fieldOf("value").forGetter(EquipmentDamageModifier::value), (App)MathOperation.COMPOUND_OP_CODEC.fieldOf("op").forGetter(EquipmentDamageModifier::operation)).apply((Applicative)instance, EquipmentDamageModifier::new));
    public static final Codec<Optional<EquipmentDamageModifier>> CODEC = ConditionalOps.createConditionalCodec(DIRECT_CODEC);

    public static Builder builder(NumberProvider value, MathOperation operation) {
        return new Builder(value, operation);
    }

    public static Builder builder(float constantValue, MathOperation operation) {
        return EquipmentDamageModifier.builder((NumberProvider)ConstantValue.exactly((float)constantValue), operation);
    }

    @Override
    public int compareTo(EquipmentDamageModifier o) {
        return MathOperation.PRIORITY_COMPARATOR.compare(this.operation, o.operation);
    }

    @Override
    public boolean test(ItemStack stack, LootContext context) {
        boolean a = this.equipmentPredicate.map(o -> o.test(stack)).orElse(true);
        boolean b = this.condition.map(o -> o.test((Object)context)).orElse(true);
        return a && b;
    }

    public static final class Builder {
        private final NumberProvider value;
        private final MathOperation operation;
        @Nullable
        private ItemPredicate equipmentPredicate;
        private final List<LootItemCondition> conditions = new ObjectArrayList();

        private Builder(NumberProvider value, MathOperation operation) {
            this.value = value;
            this.operation = operation;
        }

        public Builder withEquipmentPredicate(ItemPredicate.Builder builder) {
            this.equipmentPredicate = builder.build();
            return this;
        }

        public Builder withCondition(LootItemCondition.Builder condition) {
            this.conditions.add(condition.build());
            return this;
        }

        public Builder forEquipmentItem(ItemLike item) {
            return this.withEquipmentPredicate(ItemPredicate.Builder.item().of(new ItemLike[]{item}));
        }

        public Builder forEquipmentTag(TagKey<Item> tagKey) {
            return this.withEquipmentPredicate(ItemPredicate.Builder.item().of(tagKey));
        }

        public Builder againstEntities(TagKey<EntityType<?>> tagKey) {
            return this.withCondition(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)EntityPredicate.Builder.entity().of(tagKey)));
        }

        public EquipmentDamageModifier build() {
            Optional<LootItemCondition> condition = switch (this.conditions.size()) {
                case 0 -> Optional.empty();
                case 1 -> Optional.of(this.conditions.getFirst());
                default -> Optional.of(AllOfCondition.allOf(this.conditions));
            };
            return new EquipmentDamageModifier(Optional.ofNullable(this.equipmentPredicate), condition, this.value, this.operation);
        }
    }
}

