/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.List;
import java.util.Map;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.lib.EquipmentDamageModifier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.common.conditions.ConditionalOps;

public final class EquipmentDamageModifiers
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final EquipmentDamageModifiers INSTANCE = new EquipmentDamageModifiers();
    public static final String DIRECTORY = "equipment_damage_modifier";
    private ObjectList<EquipmentDamageModifier> modifiers = ObjectLists.emptyList();

    public static EquipmentDamageModifiers getInstance() {
        return INSTANCE;
    }

    private EquipmentDamageModifiers() {
        super(GSON, DIRECTORY);
    }

    public double apply(ItemStack stack, LootContext context, double baseDamage, double totalDamage) {
        List<EquipmentDamageModifier> toApply = this.modifiers.stream().filter(o -> o.test(stack, context)).sorted().toList();
        for (EquipmentDamageModifier modifier : toApply) {
            totalDamage = modifier.operation().applyCompoundingDouble(totalDamage, baseDamage, (double)modifier.value().getFloat(context));
        }
        return totalDamage;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ConditionalOps ops = this.makeConditionalOps();
        ObjectArrayList list = new ObjectArrayList();
        for (JsonElement json : object.values()) {
            EquipmentDamageModifier modifier = (EquipmentDamageModifier)LimaCoreCodecs.tryFlatDecode(EquipmentDamageModifier.CODEC, (DynamicOps)ops, (Object)json);
            if (modifier == null) continue;
            list.add((Object)modifier);
        }
        LTXIndustries.LOGGER.info("Loaded {} equipment damage modifiers.", (Object)list.size());
        this.modifiers = ObjectLists.unmodifiable((ObjectList)list);
    }
}

