/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib;

import java.util.Objects;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.entity.damage.UpgradableEquipmentDamageSource;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DeathMessageType;
import net.minecraft.world.entity.Entity;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;

public final class LTXIDeathMessageTypes {
    public static final EnumProxy<DeathMessageType> NO_ITEM_CAUSING_ENTITY_ONLY = new EnumProxy(DeathMessageType.class, new Object[]{"ltxi:no_item_causing_entity_only", (killedEntity, lastEntry, sigFall) -> {
        DamageSource source = lastEntry.source();
        Entity causingEntity = source.getEntity();
        String translationKey = "death.attack." + source.getMsgId();
        if (causingEntity != null) {
            return Component.translatable((String)translationKey, (Object[])new Object[]{killedEntity.getDisplayName(), causingEntity.getDisplayName()});
        }
        return Component.translatable((String)(translationKey + ".unowned"), (Object[])new Object[]{killedEntity.getDisplayName()});
    }});
    public static final EnumProxy<DeathMessageType> WEAPON_DEATH_MESSAGE_TYPE = new EnumProxy(DeathMessageType.class, new Object[]{"ltxi:weapon", (killedEntity, lastEntry, sigFall) -> {
        DamageSource source = lastEntry.source();
        if (source instanceof UpgradableEquipmentDamageSource) {
            UpgradableEquipmentDamageSource upgradableSource = (UpgradableEquipmentDamageSource)source;
            Entity causingEntity = source.getEntity();
            String translationKey = "death.attack." + source.getMsgId();
            if (causingEntity != null) {
                return Component.translatable((String)translationKey, (Object[])new Object[]{killedEntity.getDisplayName(), causingEntity.getDisplayName(), upgradableSource.getWeaponItem().getItem().getDescription()});
            }
            return LTXILangKeys.STRAY_PROJECTILE_DEATH_MESSAGE.translateArgs(new Object[]{killedEntity.getDisplayName(), Objects.requireNonNull(source.getDirectEntity()).getDisplayName()});
        }
        return LTXILangKeys.INVALID_WEAPON_DEATH_MESSAGE.translateArgs(new Object[]{killedEntity.getDisplayName()});
    }});

    private LTXIDeathMessageTypes() {
    }
}

