/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib;

import io.netty.buffer.ByteBuf;
import liedge.ltxindustries.entity.BubbleShieldUser;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.FloatTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;

public final class StandaloneBubbleShield
implements INBTSerializable<FloatTag>,
BubbleShieldUser {
    public static final StreamCodec<ByteBuf, StandaloneBubbleShield> STREAM_CODEC = ByteBufCodecs.FLOAT.map(StandaloneBubbleShield::new, StandaloneBubbleShield::getShieldHealth);
    private float shieldHealth;
    private int shieldInvulnerableCooldown;

    private StandaloneBubbleShield(float shieldHealth) {
        this.shieldHealth = shieldHealth;
    }

    public StandaloneBubbleShield() {
    }

    @Override
    public float getShieldHealth() {
        return this.shieldHealth;
    }

    @Override
    public void setShieldHealth(LivingEntity entity, float shieldHealth) {
        this.shieldHealth = Mth.clamp((float)shieldHealth, (float)0.0f, (float)1000.0f);
        entity.syncData(LTXIAttachmentTypes.BUBBLE_SHIELD);
    }

    @Override
    public void addShieldHealth(LivingEntity entity, float amount, float maxShield) {
        if (this.shieldHealth < maxShield) {
            float newShield = Math.min(this.shieldHealth + Math.max(amount, 0.0f), maxShield);
            this.setShieldHealth(entity, newShield);
        }
    }

    @Override
    public void reduceShieldHealth(LivingEntity entity, float amount, float minShield) {
        if (this.shieldHealth > minShield) {
            float newShield = Math.max(this.shieldHealth - Math.max(amount, 0.0f), minShield);
            this.setShieldHealth(entity, newShield);
        }
    }

    public void tickShield(LivingEntity shieldedEntity) {
        if (this.shieldInvulnerableCooldown > 0) {
            --this.shieldInvulnerableCooldown;
        }
    }

    @Override
    public boolean blockDamage(LivingEntity entity, Level level, DamageSource source, float amount) {
        if (!level.isClientSide() && !source.is(DamageTypeTags.BYPASSES_INVULNERABILITY) && this.shieldHealth > 0.0f) {
            if (this.shieldInvulnerableCooldown == 0 || source.is(DamageTypeTags.BYPASSES_COOLDOWN)) {
                this.reduceShieldHealth(entity, amount, 0.0f);
                this.shieldInvulnerableCooldown = 20;
            }
            return true;
        }
        return false;
    }

    public FloatTag serializeNBT(HolderLookup.Provider provider) {
        return FloatTag.valueOf((float)this.shieldHealth);
    }

    public void deserializeNBT(HolderLookup.Provider provider, FloatTag floatTag) {
        this.shieldHealth = floatTag.getAsFloat();
    }
}

