/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.Nullable;

public abstract class TurretTargetList {
    public static final TurretTargetList EMPTY = new Empty();

    public static TurretTargetList create() {
        return new SetBacked();
    }

    public static TurretTargetList getOrDefault(@Nullable Entity owner) {
        if (owner == null) {
            return EMPTY;
        }
        return (TurretTargetList)owner.getData(LTXIAttachmentTypes.TARGET_LIST);
    }

    private TurretTargetList() {
    }

    public abstract boolean containsTarget(Entity var1);

    public abstract boolean addTarget(Entity var1);

    public abstract void removeTarget(@Nullable Entity var1);

    public abstract void removeTargets(Collection<Entity> var1);

    private static class SetBacked
    extends TurretTargetList {
        private final Set<Entity> set = Collections.newSetFromMap(new WeakHashMap());

        private SetBacked() {
        }

        @Override
        public boolean containsTarget(Entity target) {
            return this.set.contains(target);
        }

        @Override
        public boolean addTarget(Entity target) {
            return this.set.add(target);
        }

        @Override
        public void removeTarget(@Nullable Entity target) {
            this.set.remove(target);
        }

        @Override
        public void removeTargets(Collection<Entity> targets) {
            this.set.removeAll(targets);
        }
    }

    private static class Empty
    extends TurretTargetList {
        private Empty() {
        }

        @Override
        public boolean containsTarget(Entity target) {
            return false;
        }

        @Override
        public boolean addTarget(Entity target) {
            return true;
        }

        @Override
        public void removeTarget(@Nullable Entity target) {
        }

        @Override
        public void removeTargets(Collection<Entity> targets) {
        }
    }
}

