/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Function;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseEntry;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import net.minecraft.core.Holder;

public final class MutableUpgradesContainer<U extends UpgradeBase<?, U>, T extends UpgradesContainerBase<?, U>> {
    private final Object2IntMap<Holder<U>> map = new Object2IntLinkedOpenHashMap();
    private final Function<Object2IntMap<Holder<U>>, T> containerFactory;

    public MutableUpgradesContainer(Function<Object2IntMap<Holder<U>>, T> containerFactory) {
        this.containerFactory = containerFactory;
    }

    public MutableUpgradesContainer(T container, Function<Object2IntMap<Holder<U>>, T> containerFactory) {
        this(containerFactory);
        this.map.putAll(((UpgradesContainerBase)container).getMapForCloning());
    }

    public MutableUpgradesContainer<U, T> set(Holder<U> upgrade, int upgradeRank) {
        if (this.checkRank(upgradeRank)) {
            this.map.put(upgrade, upgradeRank);
        }
        return this;
    }

    public MutableUpgradesContainer<U, T> set(Holder<U> upgrade) {
        return this.set(upgrade, 1);
    }

    public MutableUpgradesContainer<U, T> set(UpgradeBaseEntry<U> entry) {
        return this.set(entry.upgrade(), entry.upgradeRank());
    }

    public int merge(Holder<U> upgrade, int upgradeRank) {
        int previousRank;
        if (this.checkRank(upgradeRank) && upgradeRank > (previousRank = this.map.getOrDefault(upgrade, 0))) {
            this.map.put(upgrade, upgradeRank);
            return previousRank;
        }
        return -1;
    }

    public int merge(UpgradeBaseEntry<U> entry) {
        return this.merge(entry.upgrade(), entry.upgradeRank());
    }

    public MutableUpgradesContainer<U, T> remove(Holder<U> holder) {
        this.map.removeInt(holder);
        return this;
    }

    public T toImmutable() {
        return (T)((UpgradesContainerBase)this.containerFactory.apply(this.map));
    }

    private boolean checkRank(int upgradeRank) {
        boolean b;
        boolean bl = b = upgradeRank > 0 && upgradeRank <= 10;
        if (!b) {
            LTXIndustries.LOGGER.warn("Invalid upgrade rank: {}", (Object)upgradeRank);
        }
        return b;
    }
}

