/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function5;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import liedge.limacore.client.LimaComponentUtil;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.lib.upgrades.UpgradeDisplayInfo;
import liedge.ltxindustries.lib.upgrades.effect.UpgradeDataComponentType;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltip;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;

public interface UpgradeBase<CTX, U extends UpgradeBase<CTX, U>> {
    public static final int MAX_UPGRADE_RANK = 10;
    public static final Codec<Integer> UPGRADE_RANK_CODEC = Codec.intRange((int)1, (int)10);
    public static final StreamCodec<ByteBuf, Integer> UPGRADE_RANK_STREAM_CODEC = LimaStreamCodecs.varIntRange((int)1, (int)10);
    public static final Codec<DataComponentMap> COMPONENT_MAP_CODEC = DataComponentMap.makeCodec(UpgradeDataComponentType.CODEC);

    public static <CTX, U extends UpgradeBase<CTX, U>> Codec<U> createDirectCodec(ResourceKey<Registry<CTX>> contextRegistryKey, ResourceKey<Registry<U>> upgradesRegistryKey, UpgradeFactory<CTX, U> factory) {
        return RecordCodecBuilder.create(instance -> instance.group((App)UpgradeDisplayInfo.CODEC.fieldOf("display").forGetter(UpgradeBase::display), (App)UPGRADE_RANK_CODEC.optionalFieldOf("max_rank", (Object)1).forGetter(UpgradeBase::maxRank), (App)RegistryCodecs.homogeneousList((ResourceKey)contextRegistryKey).fieldOf("supported_set").forGetter(UpgradeBase::supportedSet), (App)RegistryCodecs.homogeneousList((ResourceKey)upgradesRegistryKey).fieldOf("exclusive_set").forGetter(UpgradeBase::exclusiveSet), (App)COMPONENT_MAP_CODEC.fieldOf("effects").forGetter(UpgradeBase::effects)).apply((Applicative)instance, (Function5)factory));
    }

    public static <U extends UpgradeBase<?, U>> Comparator<Holder<U>> comparingCategoryThenId() {
        return Comparator.comparing(holder -> ((UpgradeBase)holder.value()).display().category(), Comparator.comparing(String::isEmpty).thenComparing(Comparator.naturalOrder())).thenComparing(holder -> LimaRegistryUtil.getNonNullRegistryId((Holder)holder));
    }

    public UpgradeDisplayInfo display();

    public int maxRank();

    public HolderSet<CTX> supportedSet();

    public HolderSet<U> exclusiveSet();

    public DataComponentMap effects();

    default public void applyEffectsTooltips(int upgradeRank, Consumer<Component> consumer) {
        for (UpgradeTooltip tooltip : this.display().tooltips()) {
            consumer.accept((Component)LimaComponentUtil.BULLET_1_INDENT.copy().withStyle(ChatFormatting.GRAY).append(tooltip.get(upgradeRank)));
        }
        for (TypedDataComponent dataComponent : this.effects()) {
            this.processBuiltInTooltips(dataComponent, upgradeRank, component -> consumer.accept((Component)LimaComponentUtil.BULLET_1_INDENT.copy().withStyle(ChatFormatting.GRAY).append(component)));
        }
    }

    private <T> void processBuiltInTooltips(TypedDataComponent<T> dataComponent, int upgradeRank, Consumer<Component> consumer) {
        DataComponentType dataComponentType = dataComponent.type();
        if (dataComponentType instanceof UpgradeDataComponentType) {
            UpgradeDataComponentType type = (UpgradeDataComponentType)dataComponentType;
            type.appendTooltipLines(dataComponent.value(), upgradeRank, consumer);
        }
    }

    default public boolean canBeInstalledOn(Holder<CTX> upgradeContext) {
        return this.supportedSet().contains(upgradeContext);
    }

    default public boolean canBeInstalledAlongside(Holder<U> otherUpgrade) {
        return !this.exclusiveSet().contains(otherUpgrade);
    }

    default public <T> List<T> getListEffect(DataComponentType<List<T>> type) {
        return (List)this.effects().getOrDefault(type, List.of());
    }

    @FunctionalInterface
    public static interface UpgradeFactory<CTX, U extends UpgradeBase<CTX, U>>
    extends Function5<UpgradeDisplayInfo, Integer, HolderSet<CTX>, HolderSet<U>, DataComponentMap, U> {
        public U create(UpgradeDisplayInfo var1, int var2, HolderSet<CTX> var3, HolderSet<U> var4, DataComponentMap var5);

        default public U apply(UpgradeDisplayInfo display, Integer maxRank, HolderSet<CTX> supportedSet, HolderSet<U> exclusiveSet, DataComponentMap effects) {
            return this.create(display, maxRank, supportedSet, exclusiveSet, effects);
        }
    }
}

