/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import liedge.limacore.data.BootstrapObjectBuilder;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.ModResources;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeDisplayInfo;
import liedge.ltxindustries.lib.upgrades.UpgradeIcon;
import liedge.ltxindustries.lib.upgrades.effect.AttributeModifierUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.DamageAttributesUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.ItemAttributesUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltip;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class UpgradeBaseBuilder<CTX, U extends UpgradeBase<CTX, U>>
implements BootstrapObjectBuilder<U> {
    public static final String DEFAULT_DESCRIPTION_SUFFIX = "desc";
    private final ResourceKey<U> key;
    private final UpgradeBase.UpgradeFactory<CTX, U> factory;
    private final DataComponentMap.Builder effectMapBuilder = DataComponentMap.builder();
    private final Map<DataComponentType<?>, List<?>> effectLists = new Object2ObjectOpenHashMap();
    private Component title;
    private Component description;
    private final List<UpgradeTooltip> tooltips = new ObjectArrayList();
    private UpgradeIcon icon = UpgradeIcon.noRenderIcon();
    private String category = "";
    private int maxRank = 1;
    private HolderSet<CTX> supportedSet;
    private HolderSet<U> exclusiveSet = HolderSet.empty();

    public UpgradeBaseBuilder(ResourceKey<U> key, UpgradeBase.UpgradeFactory<CTX, U> factory) {
        this.key = key;
        this.factory = factory;
        this.title = this.defaultTitle();
        this.description = this.defaultDescription();
    }

    public UpgradeBaseBuilder<CTX, U> setTitle(Component title) {
        this.title = title;
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> setDescription(Component description) {
        this.description = description;
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> createDefaultTitle(LimaColor color) {
        return this.createDefaultTitle(title -> title.withStyle(color.chatStyle()));
    }

    public UpgradeBaseBuilder<CTX, U> createDefaultTitle(UnaryOperator<MutableComponent> operator) {
        this.title = (Component)operator.apply(this.defaultTitle());
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> createDefaultDescription(UnaryOperator<MutableComponent> operator) {
        this.description = (Component)operator.apply(this.defaultDescription());
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> tooltip(UpgradeTooltip tooltip) {
        this.tooltips.add(tooltip);
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> tooltip(int index, Function<String, UpgradeTooltip> function) {
        return this.tooltip(function.apply(UpgradeBaseBuilder.tooltipKey(this.key, index)));
    }

    public UpgradeBaseBuilder<CTX, U> tooltip(Component component) {
        return this.tooltip(UpgradeTooltip.of(component));
    }

    public UpgradeBaseBuilder<CTX, U> setMaxRank(int maxRank) {
        this.maxRank = Mth.clamp((int)maxRank, (int)1, (int)10);
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> supports(HolderSet<CTX> supportedSet) {
        this.supportedSet = supportedSet;
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> supports(HolderGetter<CTX> holders, TagKey<CTX> tagKey) {
        return this.supports((HolderSet<CTX>)holders.getOrThrow(tagKey));
    }

    public UpgradeBaseBuilder<CTX, U> supports(Holder<CTX> ctxObject) {
        return this.supports((HolderSet<CTX>)HolderSet.direct((Holder[])new Holder[]{ctxObject}));
    }

    @SafeVarargs
    public final UpgradeBaseBuilder<CTX, U> supports(Holder<CTX> ... ctxObjects) {
        return this.supports((HolderSet<CTX>)HolderSet.direct(ctxObjects));
    }

    public UpgradeBaseBuilder<CTX, U> exclusiveWith(HolderSet<U> exclusiveSet) {
        this.exclusiveSet = exclusiveSet;
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> exclusiveWith(HolderGetter<U> holders, TagKey<U> tagKey) {
        return this.exclusiveWith((HolderSet<U>)holders.getOrThrow(tagKey));
    }

    public <T> UpgradeBaseBuilder<CTX, U> withEffect(DataComponentType<List<T>> type, T effect) {
        this.getEffectsList(type).add(effect);
        return this;
    }

    public <T> UpgradeBaseBuilder<CTX, U> withEffect(Supplier<? extends DataComponentType<List<T>>> typeSupplier, T effect) {
        return this.withEffect(typeSupplier.get(), effect);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withConditionalEffect(DataComponentType<List<ConditionalEffect<T>>> type, T effect, @Nullable LootItemCondition.Builder condition) {
        this.getEffectsList(type).add(new ConditionalEffect(effect, Optional.ofNullable(condition).map(LootItemCondition.Builder::build)));
        return this;
    }

    public <T> UpgradeBaseBuilder<CTX, U> withConditionalEffect(DataComponentType<List<ConditionalEffect<T>>> type, T effect) {
        return this.withConditionalEffect(type, effect, null);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withConditionalEffect(Supplier<? extends DataComponentType<List<ConditionalEffect<T>>>> typeSupplier, T effect, @Nullable LootItemCondition.Builder condition) {
        return this.withConditionalEffect(typeSupplier.get(), effect, condition);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withConditionalEffect(Supplier<? extends DataComponentType<List<ConditionalEffect<T>>>> typeSupplier, T effect) {
        return this.withConditionalEffect(typeSupplier, effect, null);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withTargetedEffect(DataComponentType<List<TargetedConditionalEffect<T>>> type, EnchantmentTarget enchanted, EnchantmentTarget affected, T effect, @Nullable LootItemCondition.Builder condition) {
        this.getEffectsList(type).add(new TargetedConditionalEffect(enchanted, affected, effect, Optional.ofNullable(condition).map(LootItemCondition.Builder::build)));
        return this;
    }

    public <T> UpgradeBaseBuilder<CTX, U> withTargetedEffect(DataComponentType<List<TargetedConditionalEffect<T>>> type, EnchantmentTarget enchanted, EnchantmentTarget affected, T effect) {
        return this.withTargetedEffect(type, enchanted, affected, effect, null);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withTargetedEffect(Supplier<? extends DataComponentType<List<TargetedConditionalEffect<T>>>> typeSupplier, EnchantmentTarget enchanted, EnchantmentTarget affected, T effect, @Nullable LootItemCondition.Builder condition) {
        return this.withTargetedEffect(typeSupplier.get(), enchanted, affected, effect, condition);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withTargetedEffect(Supplier<? extends DataComponentType<List<TargetedConditionalEffect<T>>>> typeSupplier, EnchantmentTarget enchanted, EnchantmentTarget affected, T effect) {
        return this.withTargetedEffect(typeSupplier, enchanted, affected, effect, null);
    }

    public <T> UpgradeBaseBuilder<CTX, U> withSpecialEffect(DataComponentType<T> type, T effect) {
        this.effectMapBuilder.set(type, effect);
        return this;
    }

    public <T> UpgradeBaseBuilder<CTX, U> withSpecialEffect(Supplier<? extends DataComponentType<T>> typeSupplier, T effect) {
        return this.withSpecialEffect(typeSupplier.get(), effect);
    }

    public UpgradeBaseBuilder<CTX, U> withUnitEffect(DataComponentType<Unit> type) {
        return this.withSpecialEffect(type, Unit.INSTANCE);
    }

    public UpgradeBaseBuilder<CTX, U> withUnitEffect(Supplier<? extends DataComponentType<Unit>> typeSupplier) {
        return this.withUnitEffect(typeSupplier.get());
    }

    private <T extends AttributeModifierUpgradeEffect> UpgradeBaseBuilder<CTX, U> attributeEffect(Supplier<? extends DataComponentType<List<T>>> typeSupplier, String name, Function<ResourceLocation, T> function) {
        ResourceLocation modifierId = this.key.location().withSuffix("." + name);
        return this.withEffect(typeSupplier, (AttributeModifierUpgradeEffect)function.apply(modifierId));
    }

    public UpgradeBaseBuilder<CTX, U> itemAttributes(Holder<Attribute> attribute, String name, LevelBasedValue amount, AttributeModifier.Operation operation, EquipmentSlotGroup slots) {
        return this.attributeEffect((Supplier)LTXIUpgradeEffectComponents.ITEM_ATTRIBUTE_MODIFIERS, name, (Function)id -> ItemAttributesUpgradeEffect.create(attribute, id, amount, operation, slots));
    }

    public UpgradeBaseBuilder<CTX, U> damageAttributes(Holder<Attribute> attribute, String name, LevelBasedValue amount, AttributeModifier.Operation operation) {
        return this.attributeEffect((Supplier)LTXIUpgradeEffectComponents.DAMAGE_ATTRIBUTE_MODIFIERS, name, (Function)id -> DamageAttributesUpgradeEffect.create(attribute, id, amount, operation));
    }

    public UpgradeBaseBuilder<CTX, U> effectIcon(UpgradeIcon icon) {
        this.icon = icon;
        return this;
    }

    public UpgradeBaseBuilder<CTX, U> category(String category) {
        this.category = StringUtils.isNotBlank((CharSequence)category) ? category : "";
        return this;
    }

    public ResourceKey<U> key() {
        return this.key;
    }

    public U build() {
        UpgradeDisplayInfo displayInfo = new UpgradeDisplayInfo(this.title, this.description, this.tooltips, this.icon, this.category);
        return this.factory.apply(displayInfo, this.maxRank, this.supportedSet, this.exclusiveSet, this.effectMapBuilder.build());
    }

    private <T> List<T> getEffectsList(DataComponentType<List<T>> type) {
        return this.effectLists.computeIfAbsent(type, key -> {
            ObjectArrayList list = new ObjectArrayList();
            this.effectMapBuilder.set(type, (Object)list);
            return list;
        });
    }

    private MutableComponent defaultTitle() {
        return Component.translatable((String)UpgradeBaseBuilder.defaultTitleKey(this.key));
    }

    private MutableComponent defaultDescription() {
        return Component.translatable((String)UpgradeBaseBuilder.defaultDescriptionKey(this.key));
    }

    public static String defaultTitleKey(ResourceKey<? extends UpgradeBase<?, ?>> key) {
        return ModResources.registryPrefixedIdLangKey(key);
    }

    public static String defaultDescriptionKey(ResourceKey<? extends UpgradeBase<?, ?>> key) {
        return ModResources.registryPrefixVariantIdLangKey(key, (String)DEFAULT_DESCRIPTION_SUFFIX);
    }

    public static String tooltipKey(ResourceKey<? extends UpgradeBase<?, ?>> key, int index) {
        return ModResources.registryPrefixVariantIdLangKey(key, (String)("tooltip" + index));
    }
}

