/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.data.LimaEnumCodec;
import liedge.ltxindustries.LTXIndustries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public interface UpgradeIcon {
    public static final Codec<UpgradeIcon> CODEC = Type.CODEC.dispatchWithInline(SpriteSheetIcon.class, SpriteSheetIcon.INLINE_CODEC, UpgradeIcon::getType, Type::getCodec);
    public static final ResourceLocation DEFAULT_ICON_LOCATION = LTXIndustries.RESOURCES.location("default");

    public static NoRenderIcon noRenderIcon() {
        return NoRenderIcon.INSTANCE;
    }

    public static SpriteSheetIcon sprite(ResourceLocation location) {
        return new SpriteSheetIcon(location);
    }

    public static SpriteSheetIcon sprite(String path) {
        return UpgradeIcon.sprite(LTXIndustries.RESOURCES.location(path));
    }

    public static ItemStackIcon itemIcon(ItemStack stack) {
        return new ItemStackIcon(stack);
    }

    public static ItemStackIcon itemIcon(ItemLike itemLike) {
        return UpgradeIcon.itemIcon(new ItemStack(itemLike));
    }

    public static CompositeIcon compositeIcon(UpgradeIcon background, UpgradeIcon overlay, int overlaySize, int xOffset, int yOffset) {
        return new CompositeIcon(background, overlay, overlaySize, xOffset, yOffset);
    }

    public Type getType();

    public static final class NoRenderIcon
    implements UpgradeIcon {
        private static final NoRenderIcon INSTANCE = new NoRenderIcon();
        private static final MapCodec<NoRenderIcon> MAP_CODEC = MapCodec.unit((Object)INSTANCE);

        private NoRenderIcon() {
        }

        @Override
        public Type getType() {
            return Type.NO_RENDER;
        }
    }

    public record SpriteSheetIcon(ResourceLocation location) implements UpgradeIcon
    {
        private static final Codec<SpriteSheetIcon> INLINE_CODEC = ResourceLocation.CODEC.xmap(SpriteSheetIcon::new, SpriteSheetIcon::location);
        private static final MapCodec<SpriteSheetIcon> MAP_CODEC = INLINE_CODEC.fieldOf("sprite");

        @Override
        public Type getType() {
            return Type.UPGRADE_SPRITE;
        }
    }

    public record ItemStackIcon(ItemStack stack) implements UpgradeIcon
    {
        private static final Codec<ItemStackIcon> CODEC = ItemStack.SINGLE_ITEM_CODEC.xmap(ItemStackIcon::new, ItemStackIcon::stack);
        private static final MapCodec<ItemStackIcon> MAP_CODEC = CODEC.fieldOf("item");

        @Override
        public Type getType() {
            return Type.ITEM_STACK;
        }
    }

    public record CompositeIcon(UpgradeIcon background, UpgradeIcon overlay, int overlaySize, int xOffset, int yOffset) implements UpgradeIcon
    {
        private static final Codec<UpgradeIcon> SUB_CODEC = LimaCoreCodecs.xorSubclassCodec(SpriteSheetIcon.INLINE_CODEC, ItemStackIcon.CODEC, SpriteSheetIcon.class, ItemStackIcon.class);
        private static final MapCodec<CompositeIcon> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SUB_CODEC.fieldOf("background").forGetter(CompositeIcon::background), (App)SUB_CODEC.fieldOf("overlay").forGetter(CompositeIcon::overlay), (App)Codec.intRange((int)4, (int)16).fieldOf("overlay_size").forGetter(CompositeIcon::overlaySize), (App)Codec.INT.fieldOf("x_offset").forGetter(CompositeIcon::xOffset), (App)Codec.INT.fieldOf("y_offset").forGetter(CompositeIcon::yOffset)).apply((Applicative)instance, CompositeIcon::new)).validate(CompositeIcon::validate);

        private static DataResult<CompositeIcon> validate(CompositeIcon icon) {
            int maxOffset = 16 - icon.overlaySize;
            if (icon.xOffset < 0 || icon.xOffset > maxOffset) {
                return DataResult.error(() -> "X offset out of valid range [0," + maxOffset + ")");
            }
            if (icon.yOffset < 0 || icon.yOffset > maxOffset) {
                return DataResult.error(() -> "Y offset out of valid range [0," + maxOffset + ")");
            }
            return DataResult.success((Object)icon);
        }

        @Override
        public Type getType() {
            return Type.COMPOSITE;
        }
    }

    public static enum Type implements StringRepresentable
    {
        NO_RENDER("no_render", NoRenderIcon.MAP_CODEC),
        UPGRADE_SPRITE("upgrade_sprite", SpriteSheetIcon.MAP_CODEC),
        ITEM_STACK("item_stack", ItemStackIcon.MAP_CODEC),
        COMPOSITE("composite", CompositeIcon.MAP_CODEC);

        public static final LimaEnumCodec<Type> CODEC;
        private final String name;
        private final MapCodec<? extends UpgradeIcon> codec;

        private Type(String name, MapCodec<? extends UpgradeIcon> codec) {
            this.name = name;
            this.codec = codec;
        }

        public MapCodec<? extends UpgradeIcon> getCodec() {
            return this.codec;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = LimaEnumCodec.create(Type.class);
        }
    }
}

