/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.lib.function.ObjectIntConsumer;
import liedge.limacore.lib.function.ObjectIntFunction;
import liedge.limacore.lib.math.MathOperation;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.util.LimaLootUtil;
import liedge.limacore.util.LimaRegistryUtil;
import liedge.limacore.util.LimaStreamsUtil;
import liedge.ltxindustries.lib.upgrades.EffectRankPair;
import liedge.ltxindustries.lib.upgrades.MutableUpgradesContainer;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradeBaseEntry;
import liedge.ltxindustries.lib.upgrades.effect.EnchantmentLevelsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.level.storage.loot.LootContext;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;
import org.jetbrains.annotations.ApiStatus;

public abstract class UpgradesContainerBase<CTX, U extends UpgradeBase<CTX, U>> {
    private final Object2IntMap<Holder<U>> internalMap;
    private final int mapHash;

    protected static <CTX, U extends UpgradeBase<CTX, U>, T extends UpgradesContainerBase<CTX, U>> Codec<T> createCodec(Codec<Holder<U>> upgradeCodec, Function<Object2IntMap<Holder<U>>, T> factory) {
        return LimaCoreCodecs.object2IntLinkedHashMap(upgradeCodec, UpgradeBase.UPGRADE_RANK_CODEC).xmap(factory, UpgradesContainerBase::getMapForCloning);
    }

    protected static <CTX, U extends UpgradeBase<CTX, U>, T extends UpgradesContainerBase<CTX, U>> StreamCodec<RegistryFriendlyByteBuf, T> createStreamCodec(StreamCodec<RegistryFriendlyByteBuf, Holder<U>> upgradeStreamCodec, Function<Object2IntMap<Holder<U>>, T> factory) {
        return LimaStreamCodecs.object2IntLinkedMap(upgradeStreamCodec, UpgradeBase.UPGRADE_RANK_STREAM_CODEC).map(factory, UpgradesContainerBase::getMapForCloning);
    }

    protected UpgradesContainerBase(Object2IntMap<Holder<U>> internalMap) {
        this.internalMap = internalMap;
        this.mapHash = internalMap.hashCode();
    }

    public <T> void forEachEffect(DataComponentType<List<T>> type, ObjectIntConsumer<T> consumer) {
        for (Object2IntMap.Entry entry : this.internalMap.object2IntEntrySet()) {
            List<T> effects = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(type);
            int rank = entry.getIntValue();
            for (T effect : effects) {
                consumer.acceptWithInt(effect, rank);
            }
        }
    }

    public <T> void forEachEffect(Supplier<? extends DataComponentType<List<T>>> typeSupplier, ObjectIntConsumer<T> consumer) {
        this.forEachEffect(typeSupplier.get(), consumer);
    }

    public <T> void forEachConditionalEffect(DataComponentType<List<ConditionalEffect<T>>> type, LootContext context, ObjectIntConsumer<T> consumer) {
        for (Object2IntMap.Entry entry : this.internalMap.object2IntEntrySet()) {
            List<ConditionalEffect<T>> list = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(type);
            for (ConditionalEffect<T> conditionalEffect : list) {
                if (!conditionalEffect.matches(context)) continue;
                consumer.acceptWithInt(conditionalEffect.effect(), entry.getIntValue());
            }
        }
    }

    public <T> void forEachConditionalEffect(Supplier<? extends DataComponentType<List<ConditionalEffect<T>>>> typeSupplier, LootContext context, ObjectIntConsumer<T> consumer) {
        this.forEachConditionalEffect(typeSupplier.get(), context, consumer);
    }

    public void applyDamageContextEffects(DataComponentType<List<TargetedConditionalEffect<EntityUpgradeEffect>>> type, ServerLevel level, EnchantmentTarget effectTarget, Entity targetEntity, LivingEntity attacker, DamageSource damageSource) {
        LootContext context = LimaLootUtil.entityLootContext((ServerLevel)level, (Entity)targetEntity, (DamageSource)damageSource, (LivingEntity)attacker);
        for (Object2IntMap.Entry entry : this.internalMap.object2IntEntrySet()) {
            List<TargetedConditionalEffect<EntityUpgradeEffect>> list = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(type);
            for (TargetedConditionalEffect<EntityUpgradeEffect> conditionalEffect : list) {
                LivingEntity entity;
                if (conditionalEffect.enchanted() != effectTarget || !conditionalEffect.matches(context)) continue;
                if ((entity = (switch (conditionalEffect.affected()) {
                    default -> throw new MatchException(null, null);
                    case EnchantmentTarget.ATTACKER -> attacker;
                    case EnchantmentTarget.DAMAGING_ENTITY -> damageSource.getDirectEntity();
                    case EnchantmentTarget.VICTIM -> targetEntity;
                })) == null) continue;
                ((EntityUpgradeEffect)conditionalEffect.effect()).applyEntityEffect(level, (Entity)entity, entry.getIntValue(), context);
            }
        }
    }

    public void applyDamageContextEffects(Supplier<? extends DataComponentType<List<TargetedConditionalEffect<EntityUpgradeEffect>>>> typeSupplier, ServerLevel level, EnchantmentTarget effectTarget, Entity targetEntity, LivingEntity attacker, DamageSource damageSource) {
        this.applyDamageContextEffects(typeSupplier.get(), level, effectTarget, targetEntity, attacker, damageSource);
    }

    public <T> boolean anyMatch(DataComponentType<List<T>> type, ObjectIntFunction<T, Boolean> predicate) {
        for (Object2IntMap.Entry entry : this.internalMap.object2IntEntrySet()) {
            List<T> list = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(type);
            int rank = entry.getIntValue();
            if (!list.stream().anyMatch(effect -> (Boolean)predicate.applyWithInt(effect, rank))) continue;
            return true;
        }
        return false;
    }

    public <T> boolean noneMatch(DataComponentType<List<T>> type, ObjectIntFunction<T, Boolean> predicate) {
        return !this.anyMatch(type, predicate);
    }

    public <T> boolean upgradeEffectTypePresent(DataComponentType<T> type) {
        return this.entryStream().anyMatch(entry -> ((UpgradeBase)((Holder)entry.getKey()).value()).effects().has(type));
    }

    public <T> boolean upgradeEffectTypeAbsent(DataComponentType<T> type) {
        return this.entryStream().noneMatch(entry -> ((UpgradeBase)((Holder)entry.getKey()).value()).effects().has(type));
    }

    public <T> Stream<T> effectStream(DataComponentType<T> type) {
        return this.entryStream().map(entry -> ((UpgradeBase)((Holder)entry.getKey()).value()).effects().get(type)).filter(Objects::nonNull);
    }

    public <T> Stream<T> effectStream(Supplier<? extends DataComponentType<T>> typeSupplier) {
        return this.effectStream(typeSupplier.get());
    }

    public <T> Stream<T> effectFlatStream(DataComponentType<List<T>> type) {
        return this.entryStream().flatMap(entry -> ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(type).stream());
    }

    public <T> Stream<T> effectFlatStream(Supplier<? extends DataComponentType<List<T>>> typeSupplier) {
        return this.effectFlatStream(typeSupplier.get());
    }

    public <T> Stream<EffectRankPair<T>> boxedFlatStream(DataComponentType<List<T>> type) {
        return this.entryStream().flatMap(entry -> {
            List data = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(type);
            return data.stream().map(effect -> new EffectRankPair<Object>(effect, entry.getIntValue()));
        });
    }

    public <T> Stream<EffectRankPair<T>> boxedFlatStream(Supplier<? extends DataComponentType<List<T>>> typeSupplier) {
        return this.boxedFlatStream(typeSupplier.get());
    }

    public ItemEnchantments getEnchantments() {
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY.withTooltip(false));
        this.boxedFlatStream((Supplier)LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS).sorted(Comparator.comparing(EffectRankPair::effect, EnchantmentLevelsUpgradeEffect.DESCENDING_MAX_LEVELS_COMPARATOR)).forEach(pair -> ((EnchantmentLevelsUpgradeEffect)pair.effect()).applyEnchantment(builder, pair.upgradeRank()));
        return builder.keySet().isEmpty() ? ItemEnchantments.EMPTY : builder.toImmutable();
    }

    public void applyEnchantments(ItemStack stack) {
        stack.set(DataComponents.ENCHANTMENTS, (Object)this.getEnchantments());
    }

    public <T, R> HolderSet<R> mergeEffectHolderSets(DataComponentType<List<T>> componentType, Function<? super T, HolderSet<R>> extractor) {
        ObjectArrayList sets = new ObjectArrayList();
        for (Object2IntMap.Entry entry : this.internalMap.object2IntEntrySet()) {
            List<T> effects = ((UpgradeBase)((Holder)entry.getKey()).value()).getListEffect(componentType);
            for (T effect : effects) {
                HolderSet<R> set = extractor.apply(effect);
                if (set instanceof AnyHolderSet) {
                    return set;
                }
                sets.add(set);
            }
        }
        return LimaRegistryUtil.mergeHolderSets((List)sets);
    }

    public double applyValue(DataComponentType<List<ValueUpgradeEffect>> type, LootContext context, double base, double total) {
        List list = (List)this.boxedFlatStream(type).sorted(MathOperation.comparingPriority(p -> ((ValueUpgradeEffect)p.effect()).operation())).collect(LimaStreamsUtil.toObjectList());
        double result = total;
        for (EffectRankPair pair : list) {
            ValueUpgradeEffect effect = (ValueUpgradeEffect)pair.effect();
            result = effect.apply(context, pair.upgradeRank(), base, result);
        }
        return result;
    }

    public double applyValue(DataComponentType<List<ValueUpgradeEffect>> type, LootContext context, double base) {
        return this.applyValue(type, context, base, base);
    }

    public double applyValue(Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>> typeSupplier, LootContext context, double base, double total) {
        return this.applyValue(typeSupplier.get(), context, base, total);
    }

    public double applyValue(Supplier<? extends DataComponentType<List<ValueUpgradeEffect>>> typeSupplier, LootContext context, double base) {
        return this.applyValue(typeSupplier.get(), context, base);
    }

    public double applyConditionalValue(DataComponentType<List<ConditionalEffect<ValueUpgradeEffect>>> type, IntFunction<LootContext> contextFunction, double base, double total) {
        List list = (List)this.boxedFlatStream(type).sorted(MathOperation.comparingPriority(p -> ((ValueUpgradeEffect)((ConditionalEffect)p.effect()).effect()).operation())).collect(LimaStreamsUtil.toObjectList());
        double result = total;
        for (EffectRankPair pair : list) {
            LootContext context;
            ConditionalEffect conditionalEffect = (ConditionalEffect)pair.effect();
            if (!conditionalEffect.matches(context = contextFunction.apply(pair.upgradeRank()))) continue;
            ValueUpgradeEffect effect = (ValueUpgradeEffect)conditionalEffect.effect();
            result = effect.apply(context, pair.upgradeRank(), base, result);
        }
        return result;
    }

    public double applyConditionalValue(DataComponentType<List<ConditionalEffect<ValueUpgradeEffect>>> type, IntFunction<LootContext> contextFunction, double base) {
        return this.applyConditionalValue(type, contextFunction, base, base);
    }

    public double applyConditionalValue(Supplier<? extends DataComponentType<List<ConditionalEffect<ValueUpgradeEffect>>>> typeSupplier, IntFunction<LootContext> contextFunction, double base, double total) {
        return this.applyConditionalValue(typeSupplier.get(), contextFunction, base, total);
    }

    public double applyConditionalValue(Supplier<? extends DataComponentType<List<ConditionalEffect<ValueUpgradeEffect>>>> typeSupplier, IntFunction<LootContext> contextFunction, double base) {
        return this.applyConditionalValue(typeSupplier.get(), contextFunction, base);
    }

    public abstract MutableUpgradesContainer<U, ? extends UpgradesContainerBase<CTX, U>> toMutableContainer();

    public int size() {
        return this.internalMap.size();
    }

    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    public boolean canInstallUpgrade(Holder<CTX> contextHolder, UpgradeBaseEntry<U> entry) {
        Holder upgrade = entry.upgrade();
        if (entry.upgradeRank() <= this.getUpgradeRank(upgrade)) {
            return false;
        }
        if (!((UpgradeBase)upgrade.value()).canBeInstalledOn(contextHolder)) {
            return false;
        }
        UpgradeBase existing = (UpgradeBase)upgrade.value();
        return this.internalMap.keySet().stream().map(Holder::value).filter(o -> !existing.equals(o)).allMatch(o -> o.canBeInstalledAlongside(upgrade));
    }

    public int getUpgradeRank(Holder<U> upgradeHolder) {
        return this.internalMap.getOrDefault(upgradeHolder, 0);
    }

    public Set<Object2IntMap.Entry<Holder<U>>> toEntrySet() {
        return Collections.unmodifiableSet(this.internalMap.object2IntEntrySet());
    }

    private Stream<Object2IntMap.Entry<Holder<U>>> entryStream() {
        return this.internalMap.object2IntEntrySet().stream();
    }

    @ApiStatus.Internal
    Object2IntMap<Holder<U>> getMapForCloning() {
        return this.internalMap;
    }

    public final String toString() {
        return this.entryStream().map(entry -> String.valueOf(LimaRegistryUtil.getNonNullRegistryId((Holder)((Holder)entry.getKey()))) + "(" + entry.getIntValue() + ")").collect(Collectors.joining(","));
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof UpgradesContainerBase) {
            UpgradesContainerBase other = (UpgradesContainerBase)obj;
            return this.internalMap.equals(other.internalMap);
        }
        return false;
    }

    public final int hashCode() {
        return this.mapHash;
    }
}

