/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import java.util.function.Consumer;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltipsProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record EnchantmentLevelsUpgradeEffect(Holder<Enchantment> enchantment, LevelBasedValue levels, int maxLevel) implements UpgradeTooltipsProvider
{
    public static final Codec<EnchantmentLevelsUpgradeEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Enchantment.CODEC.fieldOf("enchantment").forGetter(EnchantmentLevelsUpgradeEffect::enchantment), (App)LevelBasedValue.CODEC.optionalFieldOf("levels", (Object)LevelBasedValue.perLevel((float)1.0f)).forGetter(EnchantmentLevelsUpgradeEffect::levels), (App)Codec.intRange((int)1, (int)255).optionalFieldOf("max_level", (Object)255).forGetter(EnchantmentLevelsUpgradeEffect::maxLevel)).apply((Applicative)instance, EnchantmentLevelsUpgradeEffect::new));
    public static final Comparator<EnchantmentLevelsUpgradeEffect> DESCENDING_MAX_LEVELS_COMPARATOR = Comparator.comparingInt(EnchantmentLevelsUpgradeEffect::maxLevel).reversed();

    public static EnchantmentLevelsUpgradeEffect fixed(Holder<Enchantment> enchantment, int level, int maxLevel) {
        return new EnchantmentLevelsUpgradeEffect(enchantment, (LevelBasedValue)LevelBasedValue.constant((float)level), maxLevel);
    }

    public static EnchantmentLevelsUpgradeEffect fixed(Holder<Enchantment> enchantment, int level) {
        return EnchantmentLevelsUpgradeEffect.fixed(enchantment, level, 255);
    }

    public static EnchantmentLevelsUpgradeEffect rankLinear(Holder<Enchantment> enchantment, int maxLevel) {
        return new EnchantmentLevelsUpgradeEffect(enchantment, (LevelBasedValue)LevelBasedValue.perLevel((float)1.0f), maxLevel);
    }

    public static EnchantmentLevelsUpgradeEffect rankLinear(Holder<Enchantment> enchantment) {
        return EnchantmentLevelsUpgradeEffect.rankLinear(enchantment, 255);
    }

    private int getValue(int upgradeRank) {
        return Mth.floor((float)this.levels.calculate(upgradeRank));
    }

    public void applyEnchantment(ItemEnchantments.Mutable builder, int upgradeRank) {
        int max = this.maxLevel - builder.getLevel(this.enchantment);
        int levelsToAdd = Math.min(this.getValue(upgradeRank), max);
        if (levelsToAdd > 0) {
            builder.upgrade(this.enchantment, levelsToAdd);
        }
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        MutableComponent enchantmentName = ((Enchantment)this.enchantment.value()).description().copy().withStyle(ChatFormatting.DARK_PURPLE);
        MutableComponent tooltip = LTXILangKeys.ENCHANTMENT_UPGRADE_EFFECT.translateArgs(new Object[]{this.getValue(upgradeRank), enchantmentName, Component.literal((String)Integer.toString(this.maxLevel)).withStyle(ChatFormatting.YELLOW)});
        lines.accept((Component)tooltip);
    }
}

