/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Consumer;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltipsProvider;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public record MiningRuleUpgradeEffect(Optional<HolderSet<Block>> effectiveBlocks, Optional<HolderSet<Block>> deniedBlocks, Optional<Float> miningSpeed, int priority) implements UpgradeTooltipsProvider,
Comparable<MiningRuleUpgradeEffect>
{
    public static final Codec<MiningRuleUpgradeEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("effective_blocks").forGetter(MiningRuleUpgradeEffect::effectiveBlocks), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BLOCK).optionalFieldOf("denied_blocks").forGetter(MiningRuleUpgradeEffect::deniedBlocks), (App)Codec.floatRange((float)1.0f, (float)99.0f).optionalFieldOf("mining_speed").forGetter(MiningRuleUpgradeEffect::miningSpeed), (App)Codec.intRange((int)1, (int)99).fieldOf("priority").forGetter(MiningRuleUpgradeEffect::priority)).apply((Applicative)instance, MiningRuleUpgradeEffect::new));

    public static MiningRuleUpgradeEffect miningLevelAndSpeed(HolderSet<Block> deniedBlocks, float miningSpeed, int priority) {
        return new MiningRuleUpgradeEffect(Optional.empty(), Optional.of(deniedBlocks), Optional.of(Float.valueOf(miningSpeed)), priority);
    }

    @Override
    public int compareTo(@NotNull MiningRuleUpgradeEffect o) {
        return Integer.compare(o.priority, this.priority);
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        this.effectiveBlocks.ifPresent(set -> lines.accept((Component)LTXILangKeys.MINING_EFFECTIVE_BLOCKS_EFFECT.translateArgs(new Object[]{LTXITooltipUtil.translateHolderSet(set).withStyle(ChatFormatting.GREEN)})));
        this.miningSpeed.ifPresent(speed -> lines.accept((Component)LTXILangKeys.MINING_BASE_SPEED_EFFECT.translateArgs(new Object[]{LTXITooltipUtil.flatNumberWithoutSign(speed.floatValue()).withStyle(ChatFormatting.GREEN)})));
    }
}

