/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import liedge.limacore.lib.damage.DamageReductionType;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltipsProvider;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueFormat;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueSentiment;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public record ModifyReductionsUpgradeEffect(DamageReductionType reductionType, LevelBasedValue amount) implements UpgradeTooltipsProvider
{
    public static final Codec<ModifyReductionsUpgradeEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DamageReductionType.CODEC.fieldOf("reduction_type").forGetter(ModifyReductionsUpgradeEffect::reductionType), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(ModifyReductionsUpgradeEffect::amount)).apply((Applicative)instance, ModifyReductionsUpgradeEffect::new));

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        float tooltipAmount = Math.abs(this.amount.calculate(upgradeRank));
        MutableComponent tooltip = LTXILangKeys.REDUCTION_MODIFIER_EFFECT.translateArgs(new Object[]{ValueFormat.PERCENTAGE.apply(tooltipAmount, ValueSentiment.POSITIVE), this.reductionType.translate().withStyle(ChatFormatting.LIGHT_PURPLE)});
        lines.accept((Component)tooltip);
    }
}

