/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltipsProvider;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public record PreventVibrationUpgradeEffect(EquipmentSlotGroup slotGroup, HolderSet<GameEvent> targetVibrations) implements UpgradeTooltipsProvider
{
    public static final Codec<PreventVibrationUpgradeEffect> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot", (Object)EquipmentSlotGroup.ANY).forGetter(PreventVibrationUpgradeEffect::slotGroup), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.GAME_EVENT).fieldOf("target").forGetter(PreventVibrationUpgradeEffect::targetVibrations)).apply((Applicative)instance, PreventVibrationUpgradeEffect::new));

    public static PreventVibrationUpgradeEffect of(EquipmentSlotGroup group, Holder<GameEvent> event) {
        return new PreventVibrationUpgradeEffect(group, (HolderSet<GameEvent>)HolderSet.direct((Holder[])new Holder[]{event}));
    }

    public static PreventVibrationUpgradeEffect alwaysSuppress(HolderSet<GameEvent> targetVibrations) {
        return new PreventVibrationUpgradeEffect(EquipmentSlotGroup.ANY, targetVibrations);
    }

    public static PreventVibrationUpgradeEffect suppressMainHand(HolderSet<GameEvent> targetVibrations) {
        return new PreventVibrationUpgradeEffect(EquipmentSlotGroup.MAINHAND, targetVibrations);
    }

    public static PreventVibrationUpgradeEffect suppressHands(HolderSet<GameEvent> targetVibrations) {
        return new PreventVibrationUpgradeEffect(EquipmentSlotGroup.HAND, targetVibrations);
    }

    public boolean apply(@Nullable EquipmentSlot slot, Holder<GameEvent> event) {
        if (slot != null && !this.slotGroup.test(slot)) {
            return false;
        }
        return this.targetVibrations.size() == 0 || this.targetVibrations.contains(event);
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        MutableComponent slotTooltip = Component.translatable((String)("item.modifiers." + this.slotGroup.getSerializedName())).append(CommonComponents.SPACE);
        slotTooltip.append((Component)LTXILangKeys.SUPPRESS_VIBRATIONS_EFFECT.translateArgs(new Object[]{LTXITooltipUtil.translateHolderSet(this.targetVibrations)}));
        lines.accept((Component)slotTooltip.withStyle(ChatFormatting.DARK_AQUA));
    }
}

