/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import liedge.ltxindustries.LTXICapabilities;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.entity.BubbleShieldUser;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffectType;
import liedge.ltxindustries.registry.game.LTXIEntityUpgradeEffects;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;

public record BubbleShieldUpgradeEffect(LevelBasedValue amount, LevelBasedValue maxShield) implements EntityUpgradeEffect
{
    public static final MapCodec<BubbleShieldUpgradeEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(BubbleShieldUpgradeEffect::amount), (App)LevelBasedValue.CODEC.optionalFieldOf("max_shield", (Object)LevelBasedValue.constant((float)1000.0f)).forGetter(BubbleShieldUpgradeEffect::maxShield)).apply((Applicative)instance, BubbleShieldUpgradeEffect::new));

    @Override
    public void applyEntityEffect(ServerLevel level, Entity entity, int upgradeRank, LootContext context) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            BubbleShieldUser user = (BubbleShieldUser)entity.getCapability(LTXICapabilities.ENTITY_BUBBLE_SHIELD);
            if (user != null) {
                user.addShieldHealth(livingEntity, this.amount.calculate(upgradeRank), this.maxShield.calculate(upgradeRank));
            }
        }
    }

    @Override
    public EntityUpgradeEffectType<?> getType() {
        return (EntityUpgradeEffectType)LTXIEntityUpgradeEffects.BUBBLE_SHIELD_EQUIPMENT_EFFECT.get();
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        MutableComponent tooltip = LTXILangKeys.BUBBLE_SHIELD_EFFECT.translateArgs(new Object[]{LTXITooltipUtil.flatNumberWithSign(this.amount.calculate(upgradeRank)).withStyle(LTXIConstants.BUBBLE_SHIELD_GREEN.chatStyle()), LTXITooltipUtil.flatNumberWithoutSign(this.maxShield.calculate(upgradeRank)).withStyle(LTXIConstants.BUBBLE_SHIELD_GREEN.chatStyle())});
        lines.accept((Component)tooltip);
    }
}

