/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect.entity;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffectType;
import liedge.ltxindustries.registry.game.LTXIEntityUpgradeEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record DynamicDamageTagUpgradeEffect(List<TagKey<DamageType>> tags) implements EntityUpgradeEffect
{
    public static final MapCodec<DynamicDamageTagUpgradeEffect> CODEC = TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).listOf().fieldOf("tags").xmap(DynamicDamageTagUpgradeEffect::new, DynamicDamageTagUpgradeEffect::tags);

    public static DynamicDamageTagUpgradeEffect of(TagKey<DamageType> key) {
        return new DynamicDamageTagUpgradeEffect(List.of(key));
    }

    @SafeVarargs
    public static DynamicDamageTagUpgradeEffect of(TagKey<DamageType> ... keys) {
        return new DynamicDamageTagUpgradeEffect(Arrays.asList(keys));
    }

    @Override
    public void applyEntityEffect(ServerLevel level, Entity entity, int upgradeRank, LootContext context) {
        DamageSource damageSource = (DamageSource)context.getParamOrNull(LootContextParams.DAMAGE_SOURCE);
        if (damageSource != null) {
            this.tags.forEach(arg_0 -> ((DamageSource)damageSource).limaCore$addDynamicTag(arg_0));
        }
    }

    @Override
    public EntityUpgradeEffectType<?> getType() {
        return (EntityUpgradeEffectType)LTXIEntityUpgradeEffects.DYNAMIC_DAMAGE_TAG_EQUIPMENT_EFFECT.get();
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        for (TagKey<DamageType> tag : this.tags) {
            MutableComponent tagComponent = Component.translatable((String)LTXILangKeys.namedDamageTagKey(tag));
            lines.accept((Component)LTXILangKeys.DYNAMIC_DAMAGE_TAG_EFFECT.translateArgs(new Object[]{tagComponent}).withStyle(ChatFormatting.AQUA));
        }
    }
}

