/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.EntityUpgradeEffectType;
import liedge.ltxindustries.registry.game.LTXIEntityUpgradeEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.StringUtil;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public record MobEffectUpgradeEffect(Holder<MobEffect> effect, LevelBasedValue duration, LevelBasedValue amplifier) implements EntityUpgradeEffect
{
    public static final MapCodec<MobEffectUpgradeEffect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(MobEffectUpgradeEffect::effect), (App)LevelBasedValue.CODEC.fieldOf("duration").forGetter(MobEffectUpgradeEffect::duration), (App)LevelBasedValue.CODEC.optionalFieldOf("amplifier", (Object)LevelBasedValue.constant((float)0.0f)).forGetter(MobEffectUpgradeEffect::amplifier)).apply((Applicative)instance, MobEffectUpgradeEffect::new));

    public static MobEffectUpgradeEffect create(Holder<MobEffect> effect, LevelBasedValue duration) {
        return new MobEffectUpgradeEffect(effect, duration, (LevelBasedValue)LevelBasedValue.constant((float)0.0f));
    }

    @Override
    public void applyEntityEffect(ServerLevel level, Entity entity, int upgradeRank, LootContext context) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            int duration = Math.round(this.duration.calculate(upgradeRank));
            int amplifier = Math.round(this.amplifier.calculate(upgradeRank));
            livingEntity.addEffect(new MobEffectInstance(this.effect, duration, amplifier), (Entity)context.getParamOrNull(LootContextParams.ATTACKING_ENTITY));
        }
    }

    @Override
    public EntityUpgradeEffectType<?> getType() {
        return (EntityUpgradeEffectType)LTXIEntityUpgradeEffects.MOB_EFFECT_EQUIPMENT_EFFECT.get();
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        MutableComponent nameComponent = ((MobEffect)this.effect.value()).getDisplayName().copy();
        int amplifier = Math.round(this.amplifier.calculate(upgradeRank));
        if (amplifier > 0 && amplifier < 10) {
            nameComponent.append(CommonComponents.SPACE).append((Component)Component.translatable((String)("enchantment.level." + (amplifier + 1))));
        }
        int duration = Math.round(this.duration.calculate(upgradeRank));
        MutableComponent durationComponent = Component.literal((String)StringUtil.formatTickDuration((int)duration, (float)20.0f));
        lines.accept((Component)LTXILangKeys.MOB_EFFECT_UPGRADE_EFFECT.translateArgs(new Object[]{nameComponent, durationComponent}).withStyle(ChatFormatting.GOLD));
    }
}

