/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.data.LimaEnumCodec;
import liedge.limacore.lib.math.MathOperation;
import net.minecraft.util.StringRepresentable;

public interface DoubleLevelBasedValue {
    public static final Codec<DoubleLevelBasedValue> CODEC = Codec.lazyInitialized(() -> Type.CODEC.dispatchWithInline(ConstantValue.class, ConstantValue.INLINE_CODEC, DoubleLevelBasedValue::getType, Type::getCodec));

    public static ConstantValue constant(double value) {
        return new ConstantValue(value);
    }

    public static LinearValue linear(double perLevel) {
        return new LinearValue(perLevel, perLevel);
    }

    public static LinearValue linear(double base, double perLevelAfterFirst) {
        return new LinearValue(base, perLevelAfterFirst);
    }

    public static Fraction constantNumerator(double numerator, DoubleLevelBasedValue denominator) {
        return new Fraction(DoubleLevelBasedValue.constant(numerator), denominator);
    }

    public static Exponential exponential(double base, DoubleLevelBasedValue power) {
        return new Exponential(base, power);
    }

    public static Exponential linearExponent(double base) {
        return DoubleLevelBasedValue.exponential(base, DoubleLevelBasedValue.linear(1.0));
    }

    public static MathOps mathOp(DoubleLevelBasedValue left, DoubleLevelBasedValue right, MathOperation operation) {
        return new MathOps(left, right, operation);
    }

    public double calculate(int var1);

    public Type getType();

    public record ConstantValue(double value) implements DoubleLevelBasedValue
    {
        private static final Codec<ConstantValue> INLINE_CODEC = Codec.DOUBLE.xmap(ConstantValue::new, ConstantValue::value);
        private static final MapCodec<ConstantValue> CODEC = INLINE_CODEC.fieldOf("value");

        @Override
        public double calculate(int level) {
            return this.value;
        }

        @Override
        public Type getType() {
            return Type.CONSTANT;
        }
    }

    public record LinearValue(double base, double perLevelAfterFirst) implements DoubleLevelBasedValue
    {
        private static final MapCodec<LinearValue> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("base").forGetter(LinearValue::base), (App)Codec.DOUBLE.fieldOf("per_level_after_first").forGetter(LinearValue::perLevelAfterFirst)).apply((Applicative)instance, LinearValue::new));

        @Override
        public double calculate(int level) {
            return this.base + this.perLevelAfterFirst * (double)(level - 1);
        }

        @Override
        public Type getType() {
            return Type.LINEAR;
        }
    }

    public record Fraction(DoubleLevelBasedValue numerator, DoubleLevelBasedValue denominator) implements DoubleLevelBasedValue
    {
        public static final MapCodec<Fraction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("numerator").forGetter(Fraction::numerator), (App)CODEC.fieldOf("denominator").forGetter(Fraction::denominator)).apply((Applicative)instance, Fraction::new));

        @Override
        public double calculate(int level) {
            return this.numerator.calculate(level) / this.denominator.calculate(level);
        }

        @Override
        public Type getType() {
            return Type.FRACTION;
        }
    }

    public record Exponential(double base, DoubleLevelBasedValue power) implements DoubleLevelBasedValue
    {
        public static final MapCodec<Exponential> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("base").forGetter(Exponential::base), (App)CODEC.fieldOf("power").forGetter(Exponential::power)).apply((Applicative)instance, Exponential::new));

        @Override
        public double calculate(int level) {
            return Math.pow(this.base, this.power.calculate(level));
        }

        @Override
        public Type getType() {
            return Type.EXPONENTIAL;
        }
    }

    public record MathOps(DoubleLevelBasedValue left, DoubleLevelBasedValue right, MathOperation operation) implements DoubleLevelBasedValue
    {
        public static final MapCodec<MathOps> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("left").forGetter(MathOps::left), (App)CODEC.fieldOf("right").forGetter(MathOps::right), (App)MathOperation.SINGLE_OP_CODEC.fieldOf("op").forGetter(MathOps::operation)).apply((Applicative)instance, MathOps::new));

        @Override
        public double calculate(int level) {
            return this.operation.applyAsDouble(this.left.calculate(level), this.right.calculate(level));
        }

        @Override
        public Type getType() {
            return Type.MATH_OPERATION;
        }
    }

    public static enum Type implements StringRepresentable
    {
        CONSTANT("constant", ConstantValue.CODEC),
        LINEAR("linear", LinearValue.CODEC),
        FRACTION("fraction", Fraction.CODEC),
        EXPONENTIAL("exponential", Exponential.CODEC),
        MATH_OPERATION("math_ops", MathOps.CODEC);

        public static final LimaEnumCodec<Type> CODEC;
        private final String name;
        private final MapCodec<? extends DoubleLevelBasedValue> codec;

        private Type(String name, MapCodec<? extends DoubleLevelBasedValue> codec) {
            this.name = name;
            this.codec = codec;
        }

        public MapCodec<? extends DoubleLevelBasedValue> getCodec() {
            return this.codec;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = LimaEnumCodec.create(Type.class);
        }
    }
}

