/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect.value;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.LevelBasedValue;

public final class RankBasedAttributeModifier {
    public static final Codec<RankBasedAttributeModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(o -> o.id), (App)LevelBasedValue.CODEC.fieldOf("amount").forGetter(o -> o.amount), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(o -> o.operation)).apply((Applicative)instance, RankBasedAttributeModifier::new));
    private final ResourceLocation id;
    private final LevelBasedValue amount;
    private final AttributeModifier.Operation operation;
    private final Function<Integer, AttributeModifier> memoizedModifiers;

    public RankBasedAttributeModifier(ResourceLocation id, LevelBasedValue amount, AttributeModifier.Operation operation) {
        this.id = id;
        this.amount = amount;
        this.operation = operation;
        this.memoizedModifiers = Util.memoize(rank -> new AttributeModifier(id, (double)amount.calculate(rank.intValue()), operation));
    }

    public AttributeModifier get(int upgradeRank) {
        return this.memoizedModifiers.apply(upgradeRank);
    }
}

