/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.effect.value;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import liedge.limacore.data.LimaEnumCodec;
import liedge.ltxindustries.lib.upgrades.effect.value.DoubleLevelBasedValue;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public interface UpgradeContextValue {
    public static final Codec<UpgradeContextValue> CODEC = Type.CODEC.dispatch(UpgradeContextValue::getType, Type::getCodec);

    public static UpgradeContextValue of(DoubleLevelBasedValue value) {
        return new SimpleValue(value);
    }

    public static UpgradeContextValue of(NumberProvider value) {
        return new LootContextValue(value);
    }

    public double get(LootContext var1, int var2);

    public Type getType();

    public record SimpleValue(DoubleLevelBasedValue value) implements UpgradeContextValue
    {
        private static final MapCodec<SimpleValue> CODEC = DoubleLevelBasedValue.CODEC.fieldOf("value").xmap(SimpleValue::new, SimpleValue::value);

        @Override
        public double get(LootContext context, int upgradeRank) {
            return this.value.calculate(upgradeRank);
        }

        @Override
        public Type getType() {
            return Type.SIMPLE_VALUE;
        }
    }

    public record LootContextValue(NumberProvider value) implements UpgradeContextValue
    {
        private static final MapCodec<LootContextValue> CODEC = NumberProviders.CODEC.fieldOf("value").xmap(LootContextValue::new, LootContextValue::value);

        @Override
        public double get(LootContext context, int upgradeRank) {
            return this.value.getFloat(context);
        }

        @Override
        public Type getType() {
            return Type.LOOT_CONTEXT_VALUE;
        }
    }

    public static enum Type implements StringRepresentable
    {
        SIMPLE_VALUE("level_based", SimpleValue.CODEC),
        LOOT_CONTEXT_VALUE("loot_context", LootContextValue.CODEC);

        private static final Codec<Type> CODEC;
        private final String name;
        private final MapCodec<? extends UpgradeContextValue> codec;

        private Type(String name, MapCodec<? extends UpgradeContextValue> codec) {
            this.name = name;
            this.codec = codec;
        }

        public String getSerializedName() {
            return this.name;
        }

        public MapCodec<? extends UpgradeContextValue> getCodec() {
            return this.codec;
        }

        static {
            CODEC = LimaEnumCodec.create(Type.class);
        }
    }
}

