/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.tooltip;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.lib.Translatable;
import liedge.ltxindustries.lib.upgrades.tooltip.TooltipArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.Style;

public sealed interface UpgradeTooltip {
    public static final Codec<UpgradeTooltip> CODEC = LimaCoreCodecs.xorSubclassCodec(StaticTooltip.CODEC, ArgsTooltip.CODEC, StaticTooltip.class, ArgsTooltip.class);

    public static UpgradeTooltip of(Component component) {
        return new StaticTooltip(component);
    }

    public static UpgradeTooltip of(String key, Style style, TooltipArgument ... args) {
        return new ArgsTooltip(key, style, List.of(args));
    }

    public static UpgradeTooltip of(String key, TooltipArgument ... args) {
        return UpgradeTooltip.of(key, Style.EMPTY, args);
    }

    public static UpgradeTooltip of(Translatable translatable, Style style, TooltipArgument ... args) {
        return UpgradeTooltip.of(translatable.descriptionId(), style, args);
    }

    public static UpgradeTooltip of(Translatable translatable, TooltipArgument ... args) {
        return UpgradeTooltip.of(translatable.descriptionId(), args);
    }

    public Component get(int var1);

    public record StaticTooltip(Component component) implements UpgradeTooltip
    {
        private static final Codec<StaticTooltip> CODEC = ComponentSerialization.CODEC.xmap(StaticTooltip::new, StaticTooltip::component);

        @Override
        public Component get(int upgradeRank) {
            return this.component;
        }
    }

    public record ArgsTooltip(String key, Style style, List<TooltipArgument> args) implements UpgradeTooltip
    {
        private static final Codec<ArgsTooltip> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(ArgsTooltip::key), (App)Style.Serializer.CODEC.optionalFieldOf("style", (Object)Style.EMPTY).forGetter(ArgsTooltip::style), (App)TooltipArgument.CODEC.listOf(1, 8).fieldOf("args").forGetter(ArgsTooltip::args)).apply((Applicative)instance, ArgsTooltip::new));

        @Override
        public Component get(int upgradeRank) {
            Object[] resolvedArgs = this.args.stream().map(a -> a.get(upgradeRank)).toArray();
            return Component.translatable((String)this.key, (Object[])resolvedArgs).withStyle(this.style);
        }
    }
}

