/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.tooltip;

import com.mojang.serialization.Codec;
import java.util.function.DoubleFunction;
import liedge.limacore.data.LimaEnumCodec;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueSentiment;
import liedge.ltxindustries.util.LTXITooltipUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.StringRepresentable;

public enum ValueFormat implements StringRepresentable
{
    FLAT_NUMBER("flat", LTXITooltipUtil::flatNumberWithoutSign),
    SIGNED_FLAT_NUMBER("signed_flat", LTXITooltipUtil::flatNumberWithSign),
    PERCENTAGE("percentage", LTXITooltipUtil::percentageWithoutSign),
    SIGNED_PERCENTAGE("signed_percentage", LTXITooltipUtil::percentageWithSign),
    MULTIPLICATIVE("multiplicative", val -> Component.literal((String)(LTXITooltipUtil.formatFlatNumber(val) + "x")));

    public static final Codec<ValueFormat> CODEC;
    private final String name;
    private final DoubleFunction<MutableComponent> function;

    private ValueFormat(String name, DoubleFunction<MutableComponent> function) {
        this.name = name;
        this.function = function;
    }

    public MutableComponent apply(double value, ValueSentiment sentiment, int zero) {
        return this.function.apply(value).withStyle(sentiment.apply(zero, value));
    }

    public MutableComponent apply(double value, ValueSentiment sentiment) {
        return this.apply(value, sentiment, 0);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = LimaEnumCodec.create(ValueFormat.class);
    }
}

