/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.upgrades.tooltip;

import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.util.StringRepresentable;

public enum ValueSentiment implements StringRepresentable
{
    NEUTRAL("neutral", ChatFormatting.GRAY, ChatFormatting.GRAY),
    POSITIVE("positive", ChatFormatting.RED, ChatFormatting.GREEN),
    NEGATIVE("negative", ChatFormatting.GREEN, ChatFormatting.RED);

    public static final LimaEnumCodec<ValueSentiment> CODEC;
    private final String name;
    private final ChatFormatting negativeColor;
    private final ChatFormatting positiveColor;

    private ValueSentiment(String name, ChatFormatting negativeColor, ChatFormatting positiveColor) {
        this.name = name;
        this.negativeColor = negativeColor;
        this.positiveColor = positiveColor;
    }

    public ChatFormatting apply(double zero, double value) {
        return value < zero ? this.negativeColor : this.positiveColor;
    }

    public ChatFormatting apply(double value) {
        return this.apply(0.0, value);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = LimaEnumCodec.create(ValueSentiment.class);
    }
}

