/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.weapons;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import liedge.limacore.lib.TickTimer;
import liedge.limacore.util.LimaCoreUtil;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.ServerWeaponControls;
import liedge.ltxindustries.lib.weapons.WeaponReloadSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWeaponControls {
    private final Object2ObjectMap<WeaponItem, TickTimer> triggerTimers = new Object2ObjectOpenHashMap();
    private final TickTimer reloadTimer = new TickTimer();
    private final TickTimer modeSwitchCooldownTimer = new TickTimer();
    private int previousSelectedSlot;
    private boolean triggerHeld;
    private int triggerTicks0;
    private int triggerTicks;
    @Nullable
    private LivingEntity focusedTarget;
    private int targetTicks;
    private int targetTicks0;

    protected boolean isInfiniteAmmo(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        return player.isCreative() || weaponItem.getReloadSource(heldItem).getType() == WeaponReloadSource.Type.INFINITE;
    }

    protected boolean hasAmmoRemaining(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        return this.isInfiniteAmmo(heldItem, player, weaponItem) || weaponItem.getAmmoLoaded(heldItem) > 0;
    }

    private boolean checkNotReloading() {
        return this.reloadTimer.getTimerState() == TickTimer.State.STOPPED;
    }

    protected boolean canReloadWeapon(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        if (weaponItem.getAmmoLoaded(heldItem) < weaponItem.getAmmoCapacity(heldItem) && !this.isTriggerHeld() && this.checkNotReloading()) {
            return player.isCreative() || weaponItem.getReloadSource(heldItem).canReload(heldItem, player, weaponItem);
        }
        return false;
    }

    protected void tickTimers() {
        ObjectIterator iterator = this.triggerTimers.object2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Object2ObjectMap.Entry e = (Object2ObjectMap.Entry)iterator.next();
            TickTimer timer = (TickTimer)e.getValue();
            timer.tickTimer();
            if (timer.getTimerState() != TickTimer.State.STOPPED) continue;
            iterator.remove();
        }
        this.reloadTimer.tickTimer();
        this.modeSwitchCooldownTimer.tickTimer();
    }

    protected void triggerTick(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        if (this.isTriggerHeld()) {
            if (weaponItem.canContinueHoldingTrigger(heldItem, player, this)) {
                weaponItem.triggerHoldingTick(heldItem, player, this);
                this.triggerTicks0 = this.triggerTicks++;
            } else {
                this.stopHoldingTrigger(heldItem, player, weaponItem, false);
            }
        }
    }

    protected void onSelectedSlotChanged(Player player, ItemStack oldItem, ItemStack newItem) {
        this.reloadTimer.stopTimer();
        Item item = oldItem.getItem();
        if (item instanceof WeaponItem) {
            WeaponItem oldWeapon = (WeaponItem)item;
            this.stopHoldingTrigger(oldItem, player, oldWeapon, false);
        }
    }

    protected void pressTrigger(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        boolean handCheck;
        boolean bl = handCheck = player.getOffhandItem().isEmpty() || weaponItem.isOneHanded(heldItem);
        if (this.checkNotReloading() && handCheck) {
            weaponItem.triggerPressed(heldItem, player, this);
        }
    }

    @Nullable
    public LivingEntity getFocusedTarget() {
        return this.focusedTarget;
    }

    public void setFocusedTarget(@Nullable LivingEntity focusedTarget) {
        this.focusedTarget = focusedTarget;
    }

    public int getTargetTicks() {
        return this.targetTicks;
    }

    public float lerpTargetTicks(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.targetTicks0, (float)this.targetTicks);
    }

    public TickTimer.State getTriggerState(WeaponItem weaponItem) {
        if (this.triggerTimers.containsKey((Object)weaponItem)) {
            return ((TickTimer)this.triggerTimers.get((Object)weaponItem)).getTimerState();
        }
        return TickTimer.State.STOPPED;
    }

    protected void startTriggerTimer(WeaponItem weaponItem, int duration) {
        TickTimer timer = new TickTimer();
        timer.startTimer(duration);
        this.triggerTimers.put((Object)weaponItem, (Object)timer);
    }

    public float lerpTriggerTimer(WeaponItem weaponItem, float partialTick) {
        if (this.triggerTimers.containsKey((Object)weaponItem)) {
            return ((TickTimer)this.triggerTimers.get((Object)weaponItem)).lerpProgressNotPaused(partialTick);
        }
        return 0.0f;
    }

    public boolean canContinueShootingWeapon(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        return this.checkNotReloading() && this.hasAmmoRemaining(heldItem, player, weaponItem);
    }

    public boolean canStartShootingWeapon(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        return this.canContinueShootingWeapon(heldItem, player, weaponItem) && this.getTriggerState(weaponItem) == TickTimer.State.STOPPED;
    }

    public ServerWeaponControls asServerControls() {
        return (ServerWeaponControls)LimaCoreUtil.castOrThrow(ServerWeaponControls.class, (Object)this, () -> new ClassCastException("Attempted to access server weapon controls on client."));
    }

    public void shootWeapon(ItemStack heldItem, Player player, WeaponItem weaponItem, boolean sendClientUpdate) {
        weaponItem.weaponFired(heldItem, player, player.level(), this);
        this.startTriggerTimer(weaponItem, weaponItem.getFireRate(heldItem));
    }

    public void startHoldingTrigger(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        if (!this.triggerHeld) {
            this.triggerHeld = true;
            weaponItem.onStartedHoldingTrigger(heldItem, player, this);
        }
    }

    public void stopHoldingTrigger(ItemStack heldItem, Player player, WeaponItem weaponItem, boolean releasedByPlayer) {
        if (this.triggerHeld) {
            this.triggerHeld = false;
            this.triggerTicks0 = 0;
            this.triggerTicks = 0;
            weaponItem.onStoppedHoldingTrigger(heldItem, player, this, releasedByPlayer);
        }
    }

    public TickTimer getReloadTimer() {
        return this.reloadTimer;
    }

    public TickTimer getModeSwitchCooldownTimer() {
        return this.modeSwitchCooldownTimer;
    }

    public boolean isTriggerHeld() {
        return this.triggerHeld;
    }

    public float lerpTriggerTicks(float partialTick) {
        return Mth.lerp((float)partialTick, (float)this.triggerTicks0, (float)this.triggerTicks);
    }

    public int getTicksHoldingTrigger() {
        return this.triggerTicks;
    }

    public void tickInput(Player player, ItemStack heldItem, @Nullable WeaponItem weaponItem) {
        this.tickTimers();
        int selectedSlot = player.getInventory().selected;
        if (this.previousSelectedSlot != selectedSlot) {
            this.onSelectedSlotChanged(player, player.getInventory().getItem(this.previousSelectedSlot), heldItem);
            this.previousSelectedSlot = selectedSlot;
        }
        if (weaponItem != null) {
            this.triggerTick(heldItem, player, weaponItem);
        }
        if (this.focusedTarget != null) {
            this.targetTicks0 = this.targetTicks++;
        } else {
            this.targetTicks = 0;
            this.targetTicks0 = 0;
        }
    }
}

