/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.weapons;

import liedge.limacore.lib.TickTimer;
import liedge.limacore.util.LimaCoreUtil;
import liedge.ltxindustries.client.AutomaticWeaponSoundInstance;
import liedge.ltxindustries.client.renderer.item.WeaponRenderer;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.network.packet.ServerboundWeaponControlsPacket;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class ClientWeaponControls
extends AbstractWeaponControls {
    private final TickTimer animationTimerA = new TickTimer();
    private final TickTimer animationTimerB = new TickTimer();
    private boolean previousLeftInput;

    public static ClientWeaponControls of(Player player) {
        AbstractWeaponControls controls = (AbstractWeaponControls)player.getData(LTXIAttachmentTypes.WEAPON_CONTROLS);
        return (ClientWeaponControls)LimaCoreUtil.castOrThrow(ClientWeaponControls.class, (Object)controls, (String)"Attempted to access client weapon controls on server.");
    }

    private void sendPacketToServer(WeaponItem weaponItem, byte action) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ServerboundWeaponControlsPacket(weaponItem, action), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public TickTimer getAnimationTimerA() {
        return this.animationTimerA;
    }

    public TickTimer getAnimationTimerB() {
        return this.animationTimerB;
    }

    public void handleServerAction(ItemStack heldItem, Player player, WeaponItem weaponItem, byte serverAction) {
        switch (serverAction) {
            case 0: {
                this.getReloadTimer().startTimer(weaponItem.getReloadSpeed(heldItem));
                break;
            }
            case 1: {
                this.shootWeapon(heldItem, player, weaponItem, false);
                break;
            }
            case 2: {
                this.startHoldingTrigger(heldItem, player, weaponItem);
                break;
            }
            case 3: {
                this.stopHoldingTrigger(heldItem, player, weaponItem, false);
            }
        }
    }

    public void handleReloadInput(Player player, ItemStack heldItem, WeaponItem weaponItem) {
        if (this.canReloadWeapon(heldItem, player, weaponItem)) {
            this.sendPacketToServer(weaponItem, (byte)2);
        }
    }

    @Override
    protected void onSelectedSlotChanged(Player player, ItemStack oldItem, ItemStack newItem) {
        super.onSelectedSlotChanged(player, oldItem, newItem);
        this.animationTimerA.stopTimer();
        this.animationTimerB.stopTimer();
    }

    @Override
    protected void tickTimers() {
        super.tickTimers();
        this.animationTimerA.tickTimer();
        this.animationTimerB.tickTimer();
    }

    @Override
    public void shootWeapon(ItemStack heldItem, Player player, WeaponItem weaponItem, boolean sendClientUpdate) {
        super.shootWeapon(heldItem, player, weaponItem, sendClientUpdate);
        WeaponRenderer.fromItem(weaponItem).onWeaponFired(heldItem, weaponItem, this);
    }

    @Override
    public void startHoldingTrigger(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        super.startHoldingTrigger(heldItem, player, weaponItem);
        if (weaponItem == LTXIItems.SUBMACHINE_GUN.get()) {
            Minecraft.getInstance().getSoundManager().play((SoundInstance)new AutomaticWeaponSoundInstance((Holder<SoundEvent>)LTXISounds.SUBMACHINE_GUN_LOOP, player));
        }
    }

    @Override
    protected void triggerTick(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        boolean leftInput;
        boolean bl = leftInput = Minecraft.getInstance().options.keyAttack.isDown() && !player.isSpectator();
        if (this.previousLeftInput != leftInput) {
            if (leftInput) {
                this.pressTrigger(heldItem, player, weaponItem);
                this.sendPacketToServer(weaponItem, (byte)0);
            } else {
                this.stopHoldingTrigger(heldItem, player, weaponItem, true);
                this.sendPacketToServer(weaponItem, (byte)1);
            }
            this.previousLeftInput = leftInput;
        }
        super.triggerTick(heldItem, player, weaponItem);
    }
}

