/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.weapons;

import java.util.function.Consumer;
import liedge.limacore.data.LimaEnumCodec;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.OrderedEnum;
import liedge.limacore.lib.Translatable;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltipsProvider;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public enum GrenadeType implements StringRepresentable,
Translatable,
OrderedEnum<GrenadeType>,
UpgradeTooltipsProvider
{
    EXPLOSIVE("explosive", LTXIConstants.EXPLOSIVE_GRAY),
    FLAME("flame", LTXIConstants.FLAME_ORANGE),
    CRYO("cryo", LTXIConstants.CRYO_LIGHT_BLUE),
    ELECTRIC("electric", LTXIConstants.ELECTRIC_GREEN),
    ACID("acid", LTXIConstants.ACID_GREEN),
    NEURO("neuro", LTXIConstants.NEURO_BLUE);

    public static final LimaEnumCodec<GrenadeType> CODEC;
    public static final StreamCodec<FriendlyByteBuf, GrenadeType> STREAM_CODEC;
    private final String name;
    private final LimaColor color;
    private final String descriptionId;

    private GrenadeType(String name, LimaColor color) {
        this.name = name;
        this.color = color;
        this.descriptionId = LTXIndustries.RESOURCES.translationKey(new String[]{"grenade_type", "{}", name});
    }

    public LimaColor getColor() {
        return this.color;
    }

    public String descriptionId() {
        return this.descriptionId;
    }

    public MutableComponent translate() {
        return super.translate().withStyle(this.color.chatStyle());
    }

    public String getSerializedName() {
        return this.name;
    }

    @Override
    public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        lines.accept((Component)LTXILangKeys.GRENADE_UNLOCK_EFFECT.translateArgs(new Object[]{this.translate()}));
    }

    static {
        CODEC = LimaEnumCodec.create(GrenadeType.class);
        STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(GrenadeType.class);
    }
}

