/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.weapons;

import liedge.limacore.lib.TickTimer;
import liedge.limacore.util.LimaEntityUtil;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.network.packet.ClientboundFocusTargetPacket;
import liedge.ltxindustries.network.packet.ClientboundWeaponControlsPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ServerWeaponControls
extends AbstractWeaponControls {
    private boolean reloadFlag;

    public ServerWeaponControls() {
        this.getReloadTimer().withStopCallback(success -> {
            this.reloadFlag = success;
        });
    }

    private void sendPacketToClient(Player player, CustomPacketPayload packet) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void sendPacketToClient(Player player, WeaponItem weaponItem, byte action) {
        this.sendPacketToClient(player, (CustomPacketPayload)new ClientboundWeaponControlsPacket(player.getId(), weaponItem, action));
    }

    public void handleClientAction(ItemStack heldItem, ServerPlayer player, WeaponItem weaponItem, byte clientAction) {
        switch (clientAction) {
            case 0: {
                this.pressTrigger(heldItem, (Player)player, weaponItem);
                break;
            }
            case 1: {
                this.stopHoldingTrigger(heldItem, (Player)player, weaponItem, true);
                break;
            }
            case 2: {
                if (!this.canReloadWeapon(heldItem, (Player)player, weaponItem)) break;
                if (this.isInfiniteAmmo(heldItem, (Player)player, weaponItem)) {
                    weaponItem.setAmmoLoadedMax(heldItem);
                    break;
                }
                this.getReloadTimer().startTimer(weaponItem.getReloadSpeed(heldItem), false);
                this.sendPacketToClient((Player)player, weaponItem, (byte)0);
            }
        }
    }

    public void setFocusedTargetAndNotify(Player player, @Nullable LivingEntity focusedTarget) {
        this.setFocusedTarget(focusedTarget);
        this.sendPacketToClient(player, (CustomPacketPayload)new ClientboundFocusTargetPacket(player.getId(), LimaEntityUtil.getEntityId((Entity)focusedTarget)));
    }

    @Override
    public void shootWeapon(ItemStack heldItem, Player player, WeaponItem weaponItem, boolean sendClientUpdate) {
        super.shootWeapon(heldItem, player, weaponItem, sendClientUpdate);
        if (!this.isInfiniteAmmo(heldItem, player, weaponItem)) {
            int ammo = weaponItem.getAmmoLoaded(heldItem);
            weaponItem.setAmmoLoaded(heldItem, ammo - 1);
        }
        if (sendClientUpdate) {
            this.sendPacketToClient(player, weaponItem, (byte)1);
        }
    }

    @Override
    public void tickInput(Player player, ItemStack heldItem, @Nullable WeaponItem weaponItem) {
        super.tickInput(player, heldItem, weaponItem);
        if (weaponItem != null && this.getReloadTimer().getTimerState() == TickTimer.State.STOPPED && this.reloadFlag) {
            if (weaponItem.getReloadSource(heldItem).performReload(heldItem, player, weaponItem)) {
                weaponItem.setAmmoLoadedMax(heldItem);
            }
            this.reloadFlag = false;
        }
    }

    @Override
    public void startHoldingTrigger(ItemStack heldItem, Player player, WeaponItem weaponItem) {
        super.startHoldingTrigger(heldItem, player, weaponItem);
        this.sendPacketToClient(player, weaponItem, (byte)2);
    }

    @Override
    public void stopHoldingTrigger(ItemStack heldItem, Player player, WeaponItem weaponItem, boolean releasedByPlayer) {
        super.stopHoldingTrigger(heldItem, player, weaponItem, releasedByPlayer);
        this.sendPacketToClient(player, weaponItem, (byte)3);
    }
}

