/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.lib.weapons;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.function.Consumer;
import java.util.stream.Stream;
import liedge.limacore.capability.energy.LimaEnergyUtil;
import liedge.limacore.data.LimaEnumCodec;
import liedge.limacore.lib.LimaColor;
import liedge.limacore.lib.Translatable;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltipsProvider;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;

public interface WeaponReloadSource
extends UpgradeTooltipsProvider {
    public static final Codec<WeaponReloadSource> CODEC = Type.CODEC.dispatch(WeaponReloadSource::getType, Type::getCodec);
    public static final StreamCodec<RegistryFriendlyByteBuf, WeaponReloadSource> STREAM_CODEC = Type.STREAM_CODEC.dispatch(WeaponReloadSource::getType, Type::getStreamCodec);

    public static WeaponReloadSource withItem(Holder<Item> holder) {
        return new ItemSource(holder);
    }

    public static WeaponReloadSource commonEnergy() {
        return CommonEnergySource.INSTANCE;
    }

    public static WeaponReloadSource infiniteAmmo() {
        return InfiniteSource.INSTANCE;
    }

    public boolean canReload(ItemStack var1, Player var2, WeaponItem var3);

    public boolean performReload(ItemStack var1, Player var2, WeaponItem var3);

    @Override
    default public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
        lines.accept((Component)this.getType().upgradeTooltip.translate().withStyle(this.getType().color.chatStyle()));
    }

    default public Component getItemTooltip() {
        return this.getType().itemTooltip.translate().withStyle(this.getType().color.chatStyle());
    }

    public Type getType();

    public record ItemSource(Holder<Item> reloadItem) implements WeaponReloadSource
    {
        private static final MapCodec<ItemSource> CODEC = ItemStack.ITEM_NON_AIR_CODEC.fieldOf("item").xmap(ItemSource::new, ItemSource::reloadItem);
        private static final StreamCodec<RegistryFriendlyByteBuf, ItemSource> STREAM_CODEC = ByteBufCodecs.holderRegistry((ResourceKey)Registries.ITEM).map(ItemSource::new, ItemSource::reloadItem);

        @Override
        public boolean canReload(ItemStack heldItem, Player player, WeaponItem weaponItem) {
            Inventory inventory = player.getInventory();
            return Stream.concat(inventory.items.stream(), inventory.offhand.stream()).anyMatch(stack -> stack.is(this.reloadItem));
        }

        @Override
        public boolean performReload(ItemStack heldItem, Player player, WeaponItem weaponItem) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack invItem = player.getInventory().getItem(i);
                if (!invItem.is(this.reloadItem)) continue;
                player.getInventory().removeItem(i, 1);
                return true;
            }
            return false;
        }

        @Override
        public Type getType() {
            return Type.ITEM;
        }

        @Override
        public void addUpgradeTooltips(int upgradeRank, Consumer<Component> lines) {
            lines.accept((Component)this.getType().upgradeTooltip.translateArgs(new Object[]{this.itemNameTooltip()}).withStyle(ChatFormatting.GRAY));
        }

        @Override
        public Component getItemTooltip() {
            return this.getType().itemTooltip.translateArgs(new Object[]{this.itemNameTooltip()}).withStyle(ChatFormatting.GRAY);
        }

        private Component itemNameTooltip() {
            return ((Item)this.reloadItem.value()).getDescription().copy().withStyle(this.getType().color.chatStyle());
        }
    }

    public static enum CommonEnergySource implements WeaponReloadSource
    {
        INSTANCE;


        @Override
        public boolean canReload(ItemStack heldItem, Player player, WeaponItem weaponItem) {
            return weaponItem.getEnergyStored(heldItem) >= weaponItem.getEnergyUsage(heldItem);
        }

        @Override
        public boolean performReload(ItemStack heldItem, Player player, WeaponItem weaponItem) {
            IEnergyStorage weaponEnergy = (IEnergyStorage)heldItem.getCapability(Capabilities.EnergyStorage.ITEM);
            return weaponEnergy != null && LimaEnergyUtil.consumeEnergy((IEnergyStorage)weaponEnergy, (int)weaponItem.getEnergyUsage(heldItem), (boolean)true);
        }

        @Override
        public Type getType() {
            return Type.COMMON_ENERGY;
        }
    }

    public static enum InfiniteSource implements WeaponReloadSource
    {
        INSTANCE;


        @Override
        public boolean canReload(ItemStack heldItem, Player player, WeaponItem weaponItem) {
            return true;
        }

        @Override
        public boolean performReload(ItemStack heldItem, Player player, WeaponItem weaponItem) {
            return true;
        }

        @Override
        public Type getType() {
            return Type.INFINITE;
        }
    }

    public static enum Type implements StringRepresentable
    {
        ITEM("item", LTXIConstants.LIME_GREEN, ItemSource.CODEC, ItemSource.STREAM_CODEC),
        COMMON_ENERGY("energy", LTXIConstants.REM_BLUE, (MapCodec<? extends WeaponReloadSource>)MapCodec.unit((Object)CommonEnergySource.INSTANCE), (StreamCodec<? super RegistryFriendlyByteBuf, ? extends WeaponReloadSource>)StreamCodec.unit((Object)CommonEnergySource.INSTANCE)),
        INFINITE("infinite", LTXIConstants.CREATIVE_PINK, (MapCodec<? extends WeaponReloadSource>)MapCodec.unit((Object)InfiniteSource.INSTANCE), (StreamCodec<? super RegistryFriendlyByteBuf, ? extends WeaponReloadSource>)StreamCodec.unit((Object)InfiniteSource.INSTANCE));

        public static final Codec<Type> CODEC;
        public static final StreamCodec<RegistryFriendlyByteBuf, Type> STREAM_CODEC;
        private final String name;
        private final LimaColor color;
        private final MapCodec<? extends WeaponReloadSource> codec;
        private final StreamCodec<? super RegistryFriendlyByteBuf, ? extends WeaponReloadSource> streamCodec;
        private final Translatable itemTooltip;
        private final Translatable upgradeTooltip;

        private Type(String name, LimaColor color, MapCodec<? extends WeaponReloadSource> codec, StreamCodec<? super RegistryFriendlyByteBuf, ? extends WeaponReloadSource> streamCodec) {
            this.name = name;
            this.color = color;
            this.codec = codec;
            this.streamCodec = streamCodec;
            this.itemTooltip = LTXILangKeys.tooltip("reload_source." + name);
            this.upgradeTooltip = LTXILangKeys.upgradeEffect("reload_source." + name);
        }

        public String getSerializedName() {
            return this.name;
        }

        public LimaColor getColor() {
            return this.color;
        }

        public MapCodec<? extends WeaponReloadSource> getCodec() {
            return this.codec;
        }

        public StreamCodec<? super RegistryFriendlyByteBuf, ? extends WeaponReloadSource> getStreamCodec() {
            return this.streamCodec;
        }

        public Translatable getItemTooltip() {
            return this.itemTooltip;
        }

        public Translatable getUpgradeTooltip() {
            return this.upgradeTooltip;
        }

        static {
            CODEC = LimaEnumCodec.create(Type.class);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Type.class);
        }
    }
}

