/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu;

import java.util.Objects;
import java.util.function.Supplier;
import liedge.limacore.blockentity.RelativeHorizontalSide;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaBlockUtil;
import liedge.ltxindustries.blockentity.base.BlockEntityInputType;
import liedge.ltxindustries.blockentity.base.BlockIOConfiguration;
import liedge.ltxindustries.blockentity.base.ConfigurableIOBlockEntity;
import liedge.ltxindustries.blockentity.base.IOConfigurationRules;
import liedge.ltxindustries.registry.game.LTXINetworkSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;

public class BlockIOConfigurationMenu
extends LimaMenu<MenuContext> {
    public static final int BACK_BUTTON_ID = 0;
    public static final int CYCLE_FORWARD_BUTTON_ID = 1;
    public static final int CYCLE_BACKWARD_BUTTON_ID = 2;
    public static final int TOGGLE_AUTO_INPUT_BUTTON_ID = 3;
    public static final int TOGGLE_AUTO_OUTPUT_BUTTON_ID = 4;

    private BlockIOConfigurationMenu(LimaMenuType<MenuContext, ?> type, int containerId, Inventory inventory, MenuContext menuContext) {
        super(type, containerId, inventory, (Object)menuContext);
        this.addDefaultPlayerInventoryAndHotbar();
    }

    public BlockIOConfiguration getIOConfiguration() {
        return ((MenuContext)this.menuContext).blockEntity.getIOConfigurationOrThrow(((MenuContext)this.menuContext).inputType);
    }

    private void setIOConfiguration(BlockIOConfiguration configuration) {
        ((MenuContext)this.menuContext).blockEntity.setIOConfiguration(((MenuContext)this.menuContext).inputType, configuration);
    }

    public IOConfigurationRules getIOConfigRules() {
        return ((MenuContext)this.menuContext).blockEntity.getIOConfigRules(((MenuContext)this.menuContext).inputType);
    }

    protected boolean quickMoveInternal(int index, ItemStack stack) {
        return false;
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(AutomaticDataWatcher.keepSynced(LTXINetworkSerializers.BLOCK_IO_CONFIG, this::getIOConfiguration, this::setIOConfiguration));
    }

    protected void defineButtonEventHandlers(LimaMenu.EventHandlerBuilder builder) {
        builder.handleUnitAction(0, ((MenuContext)this.menuContext).blockEntity::returnToPrimaryMenuScreen);
        builder.handleAction(1, (Supplier)LimaCoreNetworkSerializers.RELATIVE_SIDE, (sender, side) -> this.setIOConfiguration(this.getIOConfiguration().cycleIOAccess((RelativeHorizontalSide)side, this.getIOConfigRules(), true)));
        builder.handleAction(2, (Supplier)LimaCoreNetworkSerializers.RELATIVE_SIDE, (sender, side) -> this.setIOConfiguration(this.getIOConfiguration().cycleIOAccess((RelativeHorizontalSide)side, this.getIOConfigRules(), false)));
        builder.handleUnitAction(3, sender -> this.setIOConfiguration(this.getIOConfiguration().toggleAutoInput()));
        builder.handleUnitAction(4, sender -> this.setIOConfiguration(this.getIOConfiguration().toggleAutoOutput()));
    }

    public record MenuContext(ConfigurableIOBlockEntity blockEntity, BlockEntityInputType inputType) {
    }

    public static final class MenuType
    extends LimaMenuType<MenuContext, BlockIOConfigurationMenu> {
        public MenuType(ResourceLocation id) {
            super(MenuContext.class, BlockIOConfigurationMenu::new, MenuType.defaultMenuTitle((ResourceLocation)id));
        }

        public void encodeContext(MenuContext menuContext, RegistryFriendlyByteBuf net) {
            net.writeBlockPos(menuContext.blockEntity.getAsLimaBlockEntity().getBlockPos());
            BlockEntityInputType.STREAM_CODEC.encode((Object)net, (Object)menuContext.inputType);
        }

        protected MenuContext decodeContext(RegistryFriendlyByteBuf net, Inventory inventory) {
            BlockPos pos = net.readBlockPos();
            ConfigurableIOBlockEntity holder = Objects.requireNonNull((ConfigurableIOBlockEntity)LimaBlockUtil.getSafeBlockEntity((LevelReader)inventory.player.level(), (BlockPos)pos, ConfigurableIOBlockEntity.class));
            BlockEntityInputType inputType = (BlockEntityInputType)((Object)BlockEntityInputType.STREAM_CODEC.decode((Object)net));
            return new MenuContext(holder, inputType);
        }

        public boolean canPlayerKeepUsing(MenuContext menuContext, Player player) {
            return menuContext.blockEntity.getAsLimaBlockEntity().canPlayerUse(player);
        }
    }
}

