/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu;

import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.util.LimaLootUtil;
import liedge.ltxindustries.blockentity.EquipmentUpgradeStationBlockEntity;
import liedge.ltxindustries.item.EquipmentUpgradeModuleItem;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgradeEntry;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrades;
import liedge.ltxindustries.menu.UpgradesConfigMenu;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXINetworkSerializers;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class EquipmentUpgradeStationMenu
extends UpgradesConfigMenu<EquipmentUpgradeStationBlockEntity, EquipmentUpgrade, EquipmentUpgrades> {
    public EquipmentUpgradeStationMenu(LimaMenuType<EquipmentUpgradeStationBlockEntity, ?> type, int containerId, Inventory inventory, EquipmentUpgradeStationBlockEntity menuContext) {
        super(type, containerId, inventory, menuContext, menuContext.getItemHandlerOrThrow(BlockContentsType.GENERAL), 1);
        this.addSlot(BlockContentsType.GENERAL, 0, 24, 65, stack -> stack.getItem() instanceof UpgradableEquipmentItem);
        this.addPlayerInventoryAndHotbar(15, 118);
    }

    @Override
    protected NetworkSerializer<EquipmentUpgrades> getUpgradesSerializer() {
        return (NetworkSerializer)LTXINetworkSerializers.ITEM_EQUIPMENT_UPGRADES.get();
    }

    @Override
    protected EquipmentUpgrades getUpgrades() {
        return UpgradableEquipmentItem.getEquipmentUpgradesFromStack(this.moduleSourceInventory.getStackInSlot(0));
    }

    @Override
    protected boolean canInstallUpgrade(ItemStack upgradeModuleItem) {
        ItemStack equipmentStack = this.moduleSourceInventory.getStackInSlot(0);
        Item item = equipmentStack.getItem();
        if (item instanceof UpgradableEquipmentItem) {
            UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
            EquipmentUpgrades upgrades = equipmentItem.getUpgrades(equipmentStack);
            EquipmentUpgradeEntry entry = (EquipmentUpgradeEntry)upgradeModuleItem.get(LTXIDataComponents.EQUIPMENT_UPGRADE_ENTRY);
            return entry != null && upgrades.canInstallUpgrade(equipmentStack, entry);
        }
        return false;
    }

    @Override
    protected void tryInstallUpgrade(ItemStack upgradeModuleItem, ServerLevel level) {
        ItemStack equipmentStack = this.moduleSourceInventory.getStackInSlot(0).copy();
        Item item = equipmentStack.getItem();
        if (item instanceof UpgradableEquipmentItem) {
            UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
            EquipmentUpgrades currentUpgrades = equipmentItem.getUpgrades(equipmentStack);
            EquipmentUpgradeEntry entry = (EquipmentUpgradeEntry)upgradeModuleItem.get(LTXIDataComponents.EQUIPMENT_UPGRADE_ENTRY);
            if (entry != null && currentUpgrades.canInstallUpgrade(equipmentStack, entry)) {
                int previousRank = currentUpgrades.getUpgradeRank(entry.upgrade());
                EquipmentUpgrades newUpgrades = currentUpgrades.toMutableContainer().set(entry).toImmutable();
                this.setUpgradesAndRefresh(level, equipmentStack, equipmentItem, newUpgrades);
                this.moduleSourceInventory.setStackInSlot(0, equipmentStack);
                this.moduleSourceInventory.extractItem(1, 1, false);
                if (previousRank > 0) {
                    this.ejectModuleItem(this.getServerUser(), entry.upgrade(), previousRank);
                }
                this.sendSoundToPlayer(this.getServerUser(), (Holder)LTXISounds.UPGRADE_INSTALL, 1.0f, 1.0f);
            }
        }
    }

    @Override
    protected void tryRemoveUpgrade(ServerPlayer sender, ResourceLocation upgradeId) {
        Holder upgradeHolder;
        UpgradableEquipmentItem equipmentItem;
        EquipmentUpgrades currentUpgrades;
        int rank;
        ItemStack equipmentStack = this.moduleSourceInventory.getStackInSlot(0).copy();
        Item item = equipmentStack.getItem();
        if (item instanceof UpgradableEquipmentItem && (rank = (currentUpgrades = (equipmentItem = (UpgradableEquipmentItem)item).getUpgrades(equipmentStack)).getUpgradeRank(upgradeHolder = this.level().registryAccess().holderOrThrow(ResourceKey.create(LTXIRegistries.Keys.EQUIPMENT_UPGRADES, (ResourceLocation)upgradeId)))) > 0) {
            EquipmentUpgrades newUpgrades = currentUpgrades.toMutableContainer().remove((Holder<EquipmentUpgrade>)upgradeHolder).toImmutable();
            this.setUpgradesAndRefresh(sender.serverLevel(), equipmentStack, equipmentItem, newUpgrades);
            this.moduleSourceInventory.setStackInSlot(0, equipmentStack);
            this.ejectModuleItem(sender, upgradeHolder, rank);
            this.sendSoundToPlayer(sender, (Holder)LTXISounds.UPGRADE_REMOVE, 1.0f, 1.0f);
        }
    }

    @Override
    protected ItemStack createModuleItem(Holder<EquipmentUpgrade> upgrade, int upgradeRank) {
        return EquipmentUpgradeModuleItem.createStack(upgrade, upgradeRank);
    }

    private void setUpgradesAndRefresh(ServerLevel level, ItemStack stack, UpgradableEquipmentItem equipmentItem, EquipmentUpgrades newUpgrades) {
        equipmentItem.setUpgrades(stack, newUpgrades);
        equipmentItem.onUpgradeRefresh(LimaLootUtil.emptyLootContext((ServerLevel)level), stack, newUpgrades);
    }
}

