/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu;

import java.util.Optional;
import java.util.function.Supplier;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.util.LimaRecipesUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.blockentity.FabricatorBlockEntity;
import liedge.ltxindustries.menu.LTXIMachineMenu;
import liedge.ltxindustries.recipe.FabricatingRecipe;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public class FabricatorMenu
extends LTXIMachineMenu.RecipeEnergyMachineMenu<FabricatorBlockEntity> {
    public static final int CRAFT_BUTTON_ID = 2;
    public static final int ENCODE_BLUEPRINT_BUTTON_ID = 3;

    public FabricatorMenu(LimaMenuType<FabricatorBlockEntity, ?> type, int containerId, Inventory inventory, FabricatorBlockEntity context) {
        super(type, containerId, inventory, context);
        this.addRecipeOutputSlot(0, 42, 86);
        this.addSlot(BlockContentsType.AUXILIARY, 2, 43, 61, stack -> stack.is(((FabricatorBlockEntity)this.menuContext()).getValidBlueprintItem()));
        this.addPlayerInventoryAndHotbar(15, 118);
    }

    private Optional<RecipeHolder<FabricatingRecipe>> validateRecipeAccess(ServerPlayer sender, ResourceLocation id) {
        return LimaRecipesUtil.getRecipeById((Level)sender.level(), (ResourceLocation)id, LTXIRecipeTypes.FABRICATING).filter(holder -> FabricatingRecipe.validateUnlocked((RecipeBook)sender.getRecipeBook(), (RecipeHolder<FabricatingRecipe>)holder, (Player)sender)).or(() -> {
            LTXIndustries.LOGGER.warn("Player {} tried to access undefined or locked Fabricating recipe '{}'", (Object)sender.getName(), (Object)id);
            return Optional.empty();
        });
    }

    private void receiveCraftCommand(ServerPlayer sender, ResourceLocation id) {
        this.validateRecipeAccess(sender, id).ifPresent(holder -> ((FabricatorBlockEntity)this.menuContext).startCrafting(sender.level(), (RecipeHolder<FabricatingRecipe>)holder, LimaRecipeInput.create((IItemHandler)new PlayerMainInvWrapper(sender.getInventory()), null), sender.isCreative()));
    }

    private void receiveEncodeCommand(ServerPlayer sender, ResourceLocation id) {
        this.validateRecipeAccess(sender, id).ifPresent(holder -> {
            LimaBlockEntityItemHandler auxInventory = ((FabricatorBlockEntity)this.menuContext()).getAuxInventory();
            if (auxInventory.getStackInSlot(2).is(((FabricatorBlockEntity)this.menuContext).getValidBlueprintItem())) {
                ItemStack blueprint = new ItemStack((ItemLike)LTXIItems.FABRICATION_BLUEPRINT.asItem());
                blueprint.set(LTXIDataComponents.BLUEPRINT_RECIPE, (Object)id);
                auxInventory.extractItem(2, 1, false);
                ItemHandlerHelper.giveItemToPlayer((Player)sender, (ItemStack)blueprint);
            }
        });
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        ((FabricatorBlockEntity)this.menuContext).getEnergyStorage().keepAllPropertiesSynced(collector);
        ((FabricatorBlockEntity)this.menuContext).keepEnergyConsumerPropertiesSynced(collector);
        collector.register(((FabricatorBlockEntity)this.menuContext).keepProgressSynced());
        collector.register(((FabricatorBlockEntity)this.menuContext).getRecipeCheck().createDataWatcher());
    }

    @Override
    protected void defineButtonEventHandlers(LimaMenu.EventHandlerBuilder builder) {
        super.defineButtonEventHandlers(builder);
        builder.handleAction(2, (Supplier)LimaCoreNetworkSerializers.RESOURCE_LOCATION, this::receiveCraftCommand);
        builder.handleAction(3, (Supplier)LimaCoreNetworkSerializers.RESOURCE_LOCATION, this::receiveEncodeCommand);
    }
}

