/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu;

import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.network.NetworkSerializer;
import liedge.ltxindustries.blockentity.base.UpgradesHolderBlockEntity;
import liedge.ltxindustries.blockentity.template.LTXIMachineBlockEntity;
import liedge.ltxindustries.item.MachineUpgradeModuleItem;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrade;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgradeEntry;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrades;
import liedge.ltxindustries.menu.UpgradesConfigMenu;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXIDataComponents;
import liedge.ltxindustries.registry.game.LTXINetworkSerializers;
import liedge.ltxindustries.registry.game.LTXISounds;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class MachineUpgradeMenu
extends UpgradesConfigMenu<LTXIMachineBlockEntity, MachineUpgrade, MachineUpgrades> {
    public static final int BACK_BUTTON_ID = 1;

    public MachineUpgradeMenu(LimaMenuType<LTXIMachineBlockEntity, ?> type, int containerId, Inventory inventory, LTXIMachineBlockEntity menuContext) {
        super(type, containerId, inventory, menuContext, menuContext.getAuxInventory(), 0);
        this.addPlayerInventoryAndHotbar(15, 118);
    }

    @Override
    protected void defineButtonEventHandlers(LimaMenu.EventHandlerBuilder builder) {
        super.defineButtonEventHandlers(builder);
        builder.handleUnitAction(1, ((LTXIMachineBlockEntity)this.menuContext)::returnToPrimaryMenuScreen);
    }

    @Override
    protected NetworkSerializer<MachineUpgrades> getUpgradesSerializer() {
        return (NetworkSerializer)LTXINetworkSerializers.ITEM_MACHINE_UPGRADES.get();
    }

    @Override
    protected MachineUpgrades getUpgrades() {
        return ((LTXIMachineBlockEntity)this.menuContext).getUpgrades();
    }

    @Override
    protected boolean canInstallUpgrade(ItemStack upgradeModuleItem) {
        MachineUpgrades upgrades = ((LTXIMachineBlockEntity)this.menuContext).getUpgrades();
        MachineUpgradeEntry entry = (MachineUpgradeEntry)upgradeModuleItem.get(LTXIDataComponents.MACHINE_UPGRADE_ENTRY);
        return entry != null && upgrades.canInstallUpgrade((UpgradesHolderBlockEntity)this.menuContext, entry);
    }

    @Override
    protected void tryInstallUpgrade(ItemStack upgradeModuleItem, ServerLevel level) {
        MachineUpgrades currentUpgrades = ((LTXIMachineBlockEntity)this.menuContext).getUpgrades();
        MachineUpgradeEntry entry = (MachineUpgradeEntry)upgradeModuleItem.get(LTXIDataComponents.MACHINE_UPGRADE_ENTRY);
        if (entry != null && currentUpgrades.canInstallUpgrade((UpgradesHolderBlockEntity)this.menuContext, entry)) {
            int previousRank = currentUpgrades.getUpgradeRank(entry.upgrade());
            MachineUpgrades newUpgrades = currentUpgrades.toMutableContainer().set(entry).toImmutable();
            ((LTXIMachineBlockEntity)this.menuContext).setUpgrades(newUpgrades);
            this.moduleSourceInventory.extractItem(this.moduleSlot, 1, false);
            if (previousRank > 0) {
                this.ejectModuleItem(this.getServerUser(), entry.upgrade(), previousRank);
            }
            this.sendSoundToPlayer(this.getServerUser(), (Holder)LTXISounds.UPGRADE_INSTALL, 1.0f, 1.0f);
        }
    }

    @Override
    protected void tryRemoveUpgrade(ServerPlayer sender, ResourceLocation upgradeId) {
        Holder upgradeHolder;
        MachineUpgrades currentUpgrades = ((LTXIMachineBlockEntity)this.menuContext).getUpgrades();
        int rank = currentUpgrades.getUpgradeRank(upgradeHolder = this.level().registryAccess().holderOrThrow(ResourceKey.create(LTXIRegistries.Keys.MACHINE_UPGRADES, (ResourceLocation)upgradeId)));
        if (rank > 0) {
            MachineUpgrades newUpgrades = currentUpgrades.toMutableContainer().remove((Holder<MachineUpgrade>)upgradeHolder).toImmutable();
            ((LTXIMachineBlockEntity)this.menuContext).setUpgrades(newUpgrades);
            this.ejectModuleItem(sender, upgradeHolder, rank);
            this.sendSoundToPlayer(sender, (Holder)LTXISounds.UPGRADE_REMOVE, 1.0f, 1.0f);
        }
    }

    @Override
    protected ItemStack createModuleItem(Holder<MachineUpgrade> upgrade, int upgradeRank) {
        return MachineUpgradeModuleItem.createStack(upgrade, upgradeRank);
    }
}

