/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu;

import java.util.List;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.capability.fluid.LimaBlockEntityFluidHandler;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuProvider;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.ltxindustries.blockentity.base.RecipeModeHolderBlockEntity;
import liedge.ltxindustries.blockentity.template.BaseRecipeMachineBlockEntity;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.menu.LTXIMachineMenu;
import liedge.ltxindustries.menu.layout.LayoutSlot;
import liedge.ltxindustries.menu.layout.RecipeLayout;
import liedge.ltxindustries.registry.game.LTXIMenus;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;

public final class RecipeLayoutMenu<CTX extends BaseRecipeMachineBlockEntity<?, ?>>
extends LTXIMachineMenu.EnergyMachineMenu<CTX> {
    public static final int MODES_OPEN_BUTTON_ID = 2;
    private final RecipeLayout layout;

    public RecipeLayoutMenu(LimaMenuType<CTX, ?> type, int containerId, Inventory inventory, CTX menuContext, RecipeLayout layout) {
        super(type, containerId, inventory, menuContext);
        this.layout = layout;
        for (LayoutSlot.Type slotType : LayoutSlot.Type.values()) {
            BlockContentsType contentsType = slotType.getContentsType();
            if (contentsType == null) continue;
            List<LayoutSlot> layoutSlots = layout.getSlotsForType(slotType);
            block7: for (int i = 0; i < layoutSlots.size(); ++i) {
                LayoutSlot s = layoutSlots.get(i);
                switch (slotType) {
                    case ITEM_INPUT: {
                        this.addSlot(contentsType, i, s.x(), s.y());
                        continue block7;
                    }
                    case ITEM_OUTPUT: {
                        this.addRecipeOutputSlot(i, s.x(), s.y(), ((BaseRecipeMachineBlockEntity)menuContext).getRecipeCheck().getRecipeType());
                        continue block7;
                    }
                    case FLUID_INPUT: {
                        this.addFluidSlot((LimaFluidHandler)menuContext.getFluidHandlerOrThrow(contentsType), i, s.x(), s.y(), true);
                        continue block7;
                    }
                    case FLUID_OUTPUT: {
                        this.addFluidSlot((LimaFluidHandler)menuContext.getFluidHandlerOrThrow(contentsType), i, s.x(), s.y(), false);
                    }
                }
            }
        }
        this.addDefaultPlayerInventoryAndHotbar();
    }

    public RecipeLayout getLayout() {
        return this.layout;
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        Object object;
        LimaBlockEntityFluidHandler outputFluids;
        ((BaseRecipeMachineBlockEntity)this.menuContext).getEnergyStorage().keepAllPropertiesSynced(collector);
        ((BaseRecipeMachineBlockEntity)this.menuContext).keepTimedProcessSynced(collector);
        ((BaseRecipeMachineBlockEntity)this.menuContext).keepEnergyConsumerPropertiesSynced(collector);
        LimaBlockEntityFluidHandler inputFluids = ((BaseRecipeMachineBlockEntity)this.menuContext).getFluidHandler(BlockContentsType.INPUT);
        if (inputFluids != null) {
            inputFluids.syncAllTanks(collector);
        }
        if ((outputFluids = ((BaseRecipeMachineBlockEntity)this.menuContext).getFluidHandler(BlockContentsType.OUTPUT)) != null) {
            outputFluids.syncAllTanks(collector);
        }
        if ((object = this.menuContext) instanceof RecipeModeHolderBlockEntity) {
            RecipeModeHolderBlockEntity modeHolder = (RecipeModeHolderBlockEntity)object;
            collector.register(modeHolder.keepRecipeModeSynced());
        }
    }

    @Override
    protected void defineButtonEventHandlers(LimaMenu.EventHandlerBuilder builder) {
        super.defineButtonEventHandlers(builder);
        builder.handleUnitAction(2, this::tryOpenModesMenu);
    }

    private void tryOpenModesMenu(ServerPlayer sender) {
        Object object = this.menuContext;
        if (object instanceof RecipeModeHolderBlockEntity) {
            RecipeModeHolderBlockEntity modeHolder = (RecipeModeHolderBlockEntity)object;
            LimaMenuProvider.create((LimaMenuType)((LimaMenuType)LTXIMenus.RECIPE_MODE_SELECT.get()), (Object)modeHolder, (Component)LTXILangKeys.RECIPE_MODES_TITLE_OR_TOOLTIP.translate(), (boolean)false).openMenuScreen((Player)sender);
        }
    }
}

