/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import liedge.limacore.capability.itemhandler.ItemHolderBlockEntity;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import liedge.limacore.menu.BlockEntityMenu;
import liedge.limacore.menu.LimaMenu;
import liedge.limacore.menu.LimaMenuType;
import liedge.limacore.menu.slot.LimaHandlerSlot;
import liedge.limacore.network.NetworkSerializer;
import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.ltxindustries.lib.upgrades.UpgradeBase;
import liedge.ltxindustries.lib.upgrades.UpgradesContainerBase;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.PlayerMainInvWrapper;

public abstract class UpgradesConfigMenu<CTX extends ItemHolderBlockEntity, U extends UpgradeBase<?, U>, UC extends UpgradesContainerBase<?, U>>
extends BlockEntityMenu<CTX> {
    public static final int UPGRADE_REMOVAL_BUTTON_ID = 0;
    private int quickTransferSlot = -1;
    private final List<Object2IntMap.Entry<Holder<U>>> remoteUpgrades = new ObjectArrayList();
    protected final LimaBlockEntityItemHandler moduleSourceInventory;
    protected final int moduleSlot;
    private boolean screenUpdate = true;

    protected UpgradesConfigMenu(LimaMenuType<CTX, ?> type, int containerId, Inventory inventory, CTX menuContext, LimaBlockEntityItemHandler moduleSourceInventory, int moduleSlot) {
        super(type, containerId, inventory, menuContext);
        this.moduleSourceInventory = moduleSourceInventory;
        this.moduleSlot = moduleSlot;
        this.addSlot((Slot)new InsertSlot(24, 87));
    }

    public final ItemStack quickMoveStack(Player player, int index) {
        this.quickTransferSlot = index >= this.inventoryStart ? ((Slot)this.slots.get(index)).getContainerSlot() : -1;
        ItemStack result = super.quickMoveStack(player, index);
        this.quickTransferSlot = -1;
        return result;
    }

    public void defineDataWatchers(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(AutomaticDataWatcher.keepSynced(this.getUpgradesSerializer(), this::getUpgrades, eid -> {
            this.remoteUpgrades.clear();
            this.remoteUpgrades.addAll(eid.toEntrySet());
            this.screenUpdate = true;
        }));
    }

    protected void defineButtonEventHandlers(LimaMenu.EventHandlerBuilder builder) {
        builder.handleAction(0, (Supplier)LimaCoreNetworkSerializers.RESOURCE_LOCATION, this::tryRemoveUpgrade);
    }

    protected abstract NetworkSerializer<UC> getUpgradesSerializer();

    protected abstract UC getUpgrades();

    protected abstract boolean canInstallUpgrade(ItemStack var1);

    protected abstract void tryInstallUpgrade(ItemStack var1, ServerLevel var2);

    protected abstract void tryRemoveUpgrade(ServerPlayer var1, ResourceLocation var2);

    protected abstract ItemStack createModuleItem(Holder<U> var1, int var2);

    protected void ejectModuleItem(ServerPlayer player, Holder<U> upgrade, int upgradeRank) {
        ItemStack moduleItem = this.createModuleItem(upgrade, upgradeRank);
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(this.playerInventory);
        for (int i = 0; !(i >= inventory.getSlots() || i != this.quickTransferSlot && (moduleItem = inventory.insertItem(i, moduleItem, false)).isEmpty()); ++i) {
        }
        if (!moduleItem.isEmpty()) {
            ItemEntity itemEntity = new ItemEntity(player.level(), player.getX(), player.getY() + 0.5, player.getZ(), moduleItem);
            itemEntity.setPickUpDelay(10);
            itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            player.level().addFreshEntity((Entity)itemEntity);
        }
    }

    public List<Object2IntMap.Entry<Holder<U>>> getRemoteUpgrades() {
        return this.remoteUpgrades;
    }

    public boolean shouldUpdateScreen() {
        if (this.screenUpdate) {
            this.screenUpdate = false;
            return true;
        }
        return false;
    }

    private class InsertSlot
    extends LimaHandlerSlot {
        public InsertSlot(int xPos, int yPos) {
            super((IItemHandlerModifiable)UpgradesConfigMenu.this.moduleSourceInventory, UpgradesConfigMenu.this.moduleSlot, xPos, yPos, true, UpgradesConfigMenu.this::canInstallUpgrade);
        }

        public void setByPlayer(ItemStack stack) {
            Level level;
            super.setByPlayer(stack);
            if (!stack.isEmpty() && (level = UpgradesConfigMenu.this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                UpgradesConfigMenu.this.tryInstallUpgrade(stack, serverLevel);
            }
        }

        public boolean mayPlace(ItemStack stack) {
            return super.mayPlace(stack) && UpgradesConfigMenu.this.canInstallUpgrade(stack);
        }
    }
}

