/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.menu.layout;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import liedge.ltxindustries.menu.layout.LayoutSlot;
import liedge.ltxindustries.menu.layout.MenuLayoutMap;

public sealed interface RecipeLayout
permits MenuLayoutMap {
    public static Builder builder() {
        return new Builder();
    }

    public int progressBarX();

    public int progressBarY();

    public List<LayoutSlot> getSlotsForType(LayoutSlot.Type var1);

    public Stream<LayoutSlot> streamSlots();

    public static final class Builder {
        private final Map<LayoutSlot.Type, ObjectList<LayoutSlot>> map = new EnumMap<LayoutSlot.Type, ObjectList<LayoutSlot>>(LayoutSlot.Type.class);

        private Builder() {
        }

        public Builder slotGrid(int x0, int y0, int width, int height, LayoutSlot.Type slotType) {
            Preconditions.checkArgument((width > 0 && height > 0 ? 1 : 0) != 0);
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    this.put(slotType, x0 + x * 18, y0 + y * 18);
                }
            }
            return this;
        }

        public Builder itemIn(int x, int y) {
            return this.put(LayoutSlot.Type.ITEM_INPUT, x, y);
        }

        public Builder itemOut(int x, int y) {
            return this.put(LayoutSlot.Type.ITEM_OUTPUT, x, y);
        }

        public Builder fluidIn(int x, int y) {
            return this.put(LayoutSlot.Type.FLUID_INPUT, x, y);
        }

        public Builder fluidOut(int x, int y) {
            return this.put(LayoutSlot.Type.FLUID_OUTPUT, x, y);
        }

        public Builder modeSlot(int x, int y) {
            return this.put(LayoutSlot.Type.RECIPE_MODE, x, y);
        }

        private Builder put(LayoutSlot.Type type, int x, int y) {
            this.getList(type).add(new LayoutSlot(x, y, type));
            return this;
        }

        private List<LayoutSlot> getList(LayoutSlot.Type type) {
            return (List)this.map.computeIfAbsent(type, $ -> new ObjectArrayList());
        }

        public RecipeLayout build(int progressBarX, int progressBarY) {
            EnumMap<LayoutSlot.Type, ObjectList> out = new EnumMap<LayoutSlot.Type, ObjectList>(LayoutSlot.Type.class);
            for (LayoutSlot.Type type : LayoutSlot.Type.values()) {
                ObjectList<LayoutSlot> builder = this.map.get((Object)type);
                ObjectList l = builder != null ? ObjectLists.unmodifiable(builder) : List.of();
                out.put(type, l);
            }
            return new MenuLayoutMap(progressBarX, progressBarY, (Map<LayoutSlot.Type, List<LayoutSlot>>)ImmutableMap.copyOf(out));
        }
    }
}

