/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.network.packet;

import liedge.limacore.lib.TickTimer;
import liedge.ltxindustries.item.ScrollModeSwitchItem;
import liedge.ltxindustries.item.weapon.WeaponItem;
import liedge.ltxindustries.lib.weapons.AbstractWeaponControls;
import liedge.ltxindustries.network.packet.ServerboundItemModeSwitchPacket;
import liedge.ltxindustries.network.packet.ServerboundWeaponControlsPacket;
import liedge.ltxindustries.registry.game.LTXIAttachmentTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

final class LTXIServerPacketHandler {
    private LTXIServerPacketHandler() {
    }

    static void handleWeaponControlsPacket(ServerboundWeaponControlsPacket packet, ServerPlayer sender) {
        ItemStack heldItem = sender.getMainHandItem();
        if (heldItem.is((Item)packet.weaponItem())) {
            ((AbstractWeaponControls)sender.getData(LTXIAttachmentTypes.WEAPON_CONTROLS)).asServerControls().handleClientAction(heldItem, sender, packet.weaponItem(), packet.action());
        }
    }

    static void handleModeSwitchPacket(ServerboundItemModeSwitchPacket packet, ServerPlayer sender) {
        ItemStack heldItem;
        Item item;
        if (sender.getInventory().selected == packet.slot() && (item = (heldItem = sender.getMainHandItem()).getItem()) instanceof ScrollModeSwitchItem) {
            ScrollModeSwitchItem item2 = (ScrollModeSwitchItem)item;
            if (heldItem.getItem() instanceof WeaponItem) {
                AbstractWeaponControls controls = (AbstractWeaponControls)sender.getData(LTXIAttachmentTypes.WEAPON_CONTROLS);
                if (controls.getModeSwitchCooldownTimer().getTimerState() == TickTimer.State.STOPPED) {
                    controls.getModeSwitchCooldownTimer().startTimer(5);
                    item2.switchItemMode(heldItem, (Player)sender, packet.delta());
                }
            } else {
                item2.switchItemMode(heldItem, (Player)sender, packet.delta());
            }
        }
    }
}

