/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.recipe;

import java.util.Optional;
import liedge.ltxindustries.item.EquipmentUpgradeModuleItem;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIRecipeSerializers;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class DefaultUpgradeModuleRecipe
extends CustomRecipe {
    public DefaultUpgradeModuleRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        boolean foundEquipment = false;
        boolean foundBlankModule = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof UpgradableEquipmentItem) {
                UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
                if (foundEquipment) {
                    return true;
                }
                Registry registry = level.registryAccess().registryOrThrow(LTXIRegistries.Keys.EQUIPMENT_UPGRADES);
                ResourceKey<EquipmentUpgrade> defaultKey = equipmentItem.getDefaultUpgradeKey();
                if (defaultKey == null || !registry.containsKey(defaultKey)) {
                    return false;
                }
                foundEquipment = true;
                continue;
            }
            if (stack.is(LTXIItems.EMPTY_UPGRADE_MODULE)) {
                if (!foundBlankModule) {
                    foundBlankModule = true;
                    continue;
                }
                return false;
            }
            return false;
        }
        return foundEquipment && foundBlankModule;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        Holder defaultUpgrade = null;
        boolean foundEmptyModule = false;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            Item item = stack.getItem();
            if (item instanceof UpgradableEquipmentItem) {
                UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
                Optional holder = Optional.ofNullable(equipmentItem.getDefaultUpgradeKey()).flatMap(arg_0 -> ((HolderLookup.Provider)registries).holder(arg_0));
                if (!holder.isPresent()) continue;
                if (defaultUpgrade == null) {
                    defaultUpgrade = (Holder)holder.get();
                    continue;
                }
                return ItemStack.EMPTY;
            }
            if (stack.is(LTXIItems.EMPTY_UPGRADE_MODULE)) {
                if (!foundEmptyModule) {
                    foundEmptyModule = true;
                    continue;
                }
                return ItemStack.EMPTY;
            }
            return ItemStack.EMPTY;
        }
        return foundEmptyModule && defaultUpgrade != null ? EquipmentUpgradeModuleItem.createStack(defaultUpgrade, 1) : ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width >= 3 && height >= 3;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)LTXIRecipeSerializers.DEFAULT_UPGRADE_MODULE.get();
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput input) {
        NonNullList remainder = NonNullList.withSize((int)input.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < input.size(); ++i) {
            ItemStack stack = input.getItem(i);
            if (!(stack.getItem() instanceof UpgradableEquipmentItem)) continue;
            remainder.set(i, (Object)stack.copy());
        }
        return remainder;
    }
}

