/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import liedge.limacore.data.LimaCoreCodecs;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.recipe.result.ItemResult;
import liedge.limacore.util.LimaLootUtil;
import liedge.ltxindustries.item.UpgradableEquipmentItem;
import liedge.ltxindustries.menu.tooltip.FabricatorIngredientTooltip;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import liedge.ltxindustries.registry.game.LTXIRecipeSerializers;
import liedge.ltxindustries.registry.game.LTXIRecipeTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.RecipeBook;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public final class FabricatingRecipe
extends LimaCustomRecipe<LimaRecipeInput> {
    public static final MapCodec<FabricatingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LimaCoreCodecs.sizedIngredients((int)1, (int)16).forGetter(LimaCustomRecipe::getItemIngredients), (App)ItemResult.CODEC.fieldOf("result").forGetter(LimaCustomRecipe::getFirstItemResult), (App)ExtraCodecs.POSITIVE_INT.fieldOf("energy_required").forGetter(FabricatingRecipe::getEnergyRequired), (App)Codec.BOOL.optionalFieldOf("advancement_locked", (Object)false).forGetter(FabricatingRecipe::isAdvancementLocked), (App)GROUP_MAP_CODEC.forGetter(FabricatingRecipe::getGroup)).apply((Applicative)instance, FabricatingRecipe::new)).validate(LimaCustomRecipe::checkNotEmpty);
    public static final StreamCodec<RegistryFriendlyByteBuf, FabricatingRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)LimaStreamCodecs.sizedIngredients((int)16), LimaCustomRecipe::getItemIngredients, (StreamCodec)ItemResult.STREAM_CODEC, LimaCustomRecipe::getFirstItemResult, (StreamCodec)LimaStreamCodecs.POSITIVE_VAR_INT, FabricatingRecipe::getEnergyRequired, (StreamCodec)ByteBufCodecs.BOOL, FabricatingRecipe::isAdvancementLocked, (StreamCodec)ByteBufCodecs.STRING_UTF8, Recipe::getGroup, FabricatingRecipe::new);
    private final int energyRequired;
    private final boolean advancementLocked;
    private final String group;

    public static boolean validateUnlocked(RecipeBook recipeBook, RecipeHolder<FabricatingRecipe> recipe, Player player) {
        if (((FabricatingRecipe)recipe.value()).advancementLocked) {
            return player.isCreative() || recipeBook.contains(recipe);
        }
        return true;
    }

    public FabricatingRecipe(List<SizedIngredient> ingredients, ItemResult result, int energyRequired, boolean advancementLocked, String group) {
        super(ingredients, List.of(result));
        this.energyRequired = energyRequired;
        this.advancementLocked = advancementLocked;
        this.group = group;
    }

    public int getEnergyRequired() {
        return this.energyRequired;
    }

    public boolean isAdvancementLocked() {
        return this.advancementLocked;
    }

    public TooltipComponent createIngredientTooltip() {
        return new FabricatorIngredientTooltip(this.getItemIngredients());
    }

    public ItemStack generateItemResult(ServerLevel level) {
        ItemStack stack = this.getFirstItemResult().generateResult(level.random);
        Item item = stack.getItem();
        if (item instanceof UpgradableEquipmentItem) {
            UpgradableEquipmentItem equipmentItem = (UpgradableEquipmentItem)item;
            equipmentItem.onUpgradeRefresh(LimaLootUtil.emptyLootContext((ServerLevel)level), stack, equipmentItem.getUpgrades(stack));
        }
        return stack;
    }

    public ItemStack getFabricatingResultItem() {
        return this.getFirstItemResult().getMaximumResult();
    }

    public String getGroup() {
        return this.group;
    }

    public boolean isSpecial() {
        return false;
    }

    public ItemStack getToastSymbol() {
        return LTXIBlocks.FABRICATOR.toStack();
    }

    public RecipeType<?> getType() {
        return (RecipeType)LTXIRecipeTypes.FABRICATING.get();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)LTXIRecipeSerializers.FABRICATING.get();
    }
}

