/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.recipe;

import java.util.List;
import java.util.Objects;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.LimaRecipeInput;
import liedge.limacore.recipe.result.ItemResult;
import liedge.ltxindustries.recipe.LTXIRecipeInput;
import liedge.ltxindustries.recipe.RecipeMode;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;
import org.jetbrains.annotations.Nullable;

public abstract class LTXIRecipe
extends LimaCustomRecipe<LTXIRecipeInput> {
    public static final int DEFAULT_CRAFTING_TIME = 200;
    private final int craftTime;
    @Nullable
    private final Holder<RecipeMode> mode;

    protected LTXIRecipe(List<SizedIngredient> itemIngredients, List<SizedFluidIngredient> fluidIngredients, List<ItemResult> itemResults, List<FluidStack> fluidResults, int craftTime, @Nullable Holder<RecipeMode> mode) {
        super(itemIngredients, fluidIngredients, itemResults, fluidResults);
        this.craftTime = craftTime;
        this.mode = mode;
    }

    public int getCraftTime() {
        return this.craftTime;
    }

    @Nullable
    public Holder<RecipeMode> getMode() {
        return this.mode;
    }

    public boolean matches(LTXIRecipeInput input, Level level) {
        Holder<RecipeMode> inputMode;
        if (!(this.mode == null || (inputMode = input.mode()) != null && Objects.equals(inputMode, this.mode) && ((RecipeMode)inputMode.value()).recipeTypes().contains(this.typeHolder()))) {
            return false;
        }
        return super.matches((LimaRecipeInput)input, level);
    }

    private Holder<RecipeType<?>> typeHolder() {
        return BuiltInRegistries.RECIPE_TYPE.wrapAsHolder((Object)this.getType());
    }
}

