/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import liedge.limacore.network.LimaStreamCodecs;
import liedge.limacore.recipe.LimaCustomRecipe;
import liedge.limacore.recipe.LimaRecipeSerializerBuilder;
import liedge.ltxindustries.recipe.LTXIRecipe;
import liedge.ltxindustries.recipe.LTXIRecipeSupplier;
import liedge.ltxindustries.recipe.RecipeMode;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.crafting.RecipeSerializer;

public record LTXIRecipeSerializer<R extends LTXIRecipe>(MapCodec<R> codec, StreamCodec<RegistryFriendlyByteBuf, R> streamCodec, LTXIRecipeSupplier<R> factory, int defaultTime) implements RecipeSerializer<R>
{
    public static <R extends LTXIRecipe> Builder<R> builder(LTXIRecipeSupplier<R> factory) {
        return new Builder<R>(factory);
    }

    public static final class Builder<R extends LTXIRecipe>
    extends LimaRecipeSerializerBuilder<R, LTXIRecipeSerializer<R>, Builder<R>> {
        private final LTXIRecipeSupplier<R> factory;
        private int defaultCraftTime = 200;

        private Builder(LTXIRecipeSupplier<R> factory) {
            this.factory = factory;
        }

        public Builder<R> defaultTime(int defaultCraftTime) {
            Preconditions.checkArgument((defaultCraftTime >= 1 && defaultCraftTime < Integer.MAX_VALUE ? 1 : 0) != 0);
            this.defaultCraftTime = defaultCraftTime;
            return this;
        }

        public LTXIRecipeSerializer<R> build(ResourceLocation id) {
            MapCodec mapCodec = RecordCodecBuilder.mapCodec(instance -> this.commonFields((RecordCodecBuilder.Instance)instance).and((App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("craft_time", (Object)this.defaultCraftTime).forGetter(LTXIRecipe::getCraftTime)).and((App)RecipeMode.CODEC.optionalFieldOf("mode").forGetter(o -> Optional.ofNullable(o.getMode()))).apply((Applicative)instance, this.factory)).validate(LimaCustomRecipe::checkNotEmpty);
            StreamCodec streamCodec = StreamCodec.composite((StreamCodec)this.itemIngredientStreamCodec, LimaCustomRecipe::getItemIngredients, (StreamCodec)this.fluidIngredientStreamCodec, LimaCustomRecipe::getFluidIngredients, (StreamCodec)this.itemResultStreamCodec, LimaCustomRecipe::getItemResults, (StreamCodec)this.fluidResultStreamCodec, LimaCustomRecipe::getFluidResults, (StreamCodec)LimaStreamCodecs.POSITIVE_VAR_INT, LTXIRecipe::getCraftTime, (StreamCodec)ByteBufCodecs.optional(RecipeMode.STREAM_CODEC), o -> Optional.ofNullable(o.getMode()), this.factory);
            return new LTXIRecipeSerializer<R>(mapCodec, streamCodec, this.factory, this.defaultCraftTime);
        }
    }
}

