/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.recipe;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import liedge.limacore.data.BootstrapObjectBuilder;
import liedge.limacore.lib.LimaColor;
import liedge.ltxindustries.registry.LTXIRegistries;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public record RecipeMode(HolderSet<RecipeType<?>> recipeTypes, Component displayName, ItemStack displayItem) {
    public static final Codec<RecipeMode> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.homogeneousList((ResourceKey)Registries.RECIPE_TYPE).fieldOf("recipe_types").forGetter(RecipeMode::recipeTypes), (App)ComponentSerialization.CODEC.fieldOf("display_name").forGetter(RecipeMode::displayName), (App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("display_item").forGetter(RecipeMode::displayItem)).apply((Applicative)instance, RecipeMode::new));
    public static final Codec<Holder<RecipeMode>> CODEC = RegistryFixedCodec.create(LTXIRegistries.Keys.RECIPE_MODES);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<RecipeMode>> STREAM_CODEC = ByteBufCodecs.holderRegistry(LTXIRegistries.Keys.RECIPE_MODES);

    public static Builder builder(ResourceKey<RecipeMode> key) {
        return new Builder(key);
    }

    public static final class Builder
    implements BootstrapObjectBuilder<RecipeMode> {
        private final ResourceKey<RecipeMode> key;
        private HolderSet<RecipeType<?>> recipeTypes;
        private Component displayName;
        private ItemStack displayItem;

        private Builder(ResourceKey<RecipeMode> key) {
            this.key = key;
            this.displayName = this.defaultName();
            this.displayItem = ItemStack.EMPTY;
        }

        public Builder styledName(ChatFormatting formatting) {
            this.displayName = this.defaultName().withStyle(formatting);
            return this;
        }

        public Builder styledName(LimaColor color) {
            this.displayName = this.defaultName().withStyle(color.chatStyle());
            return this;
        }

        public Builder forTypes(HolderSet<RecipeType<?>> holderSet) {
            this.recipeTypes = holderSet;
            return this;
        }

        @SafeVarargs
        public final Builder forTypes(Holder<RecipeType<?>> ... holders) {
            return this.forTypes((HolderSet<RecipeType<?>>)HolderSet.direct(holders));
        }

        public Builder forType(Holder<RecipeType<?>> holder) {
            return this.forTypes((HolderSet<RecipeType<?>>)HolderSet.direct((Holder[])new Holder[]{holder}));
        }

        public Builder icon(ItemStack displayItem) {
            this.displayItem = displayItem;
            return this;
        }

        public Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        public ResourceKey<RecipeMode> key() {
            return this.key;
        }

        public RecipeMode build() {
            Preconditions.checkState((this.recipeTypes != null && this.recipeTypes.size() > 0 ? 1 : 0) != 0, (Object)"Empty recipe types holder set.");
            Preconditions.checkState((!this.displayItem.isEmpty() ? 1 : 0) != 0, (Object)"Empty display item.");
            return new RecipeMode(this.recipeTypes, this.displayName, this.displayItem);
        }

        private MutableComponent defaultName() {
            return Component.translatable((String)this.identityTranslationKey());
        }
    }
}

