/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.bootstrap;

import liedge.limacore.util.LimaRegistryUtil;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.registry.bootstrap.LTXIPlacedFeatures;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public final class LTXIBiomeModifiers {
    public static final ResourceKey<BiomeModifier> OVERWORLD_ORES = LTXIBiomeModifiers.key("overworld_ores");
    public static final ResourceKey<BiomeModifier> BASALT_DELTA_ORES = LTXIBiomeModifiers.key("basalt_delta_ores");
    public static final ResourceKey<BiomeModifier> OUTER_END_ORES = LTXIBiomeModifiers.key("outer_end_ores");
    public static final ResourceKey<BiomeModifier> JUNGLE_VEGETATION = LTXIBiomeModifiers.key("jungle_vegetation");
    public static final ResourceKey<BiomeModifier> NETHER_VEGETATION = LTXIBiomeModifiers.key("nether_vegetation");
    public static final ResourceKey<BiomeModifier> DEEP_DARK_VEGETATION = LTXIBiomeModifiers.key("deep_dark_vegetation");

    private LTXIBiomeModifiers() {
    }

    private static ResourceKey<BiomeModifier> key(String name) {
        return LTXIndustries.RESOURCES.resourceKey(NeoForgeRegistries.Keys.BIOME_MODIFIERS, name);
    }

    public static void bootstrap(BootstrapContext<BiomeModifier> context) {
        HolderGetter placements = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter biomes = context.lookup(Registries.BIOME);
        BiomeModifiers.AddFeaturesBiomeModifier titaniumOre = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_OVERWORLD), LimaRegistryUtil.keyHolderSet((HolderGetter)placements, LTXIPlacedFeatures.TITANIUM_ORE_PLACEMENT), GenerationStep.Decoration.UNDERGROUND_ORES);
        BiomeModifiers.AddFeaturesBiomeModifier niobiumOre = new BiomeModifiers.AddFeaturesBiomeModifier(LimaRegistryUtil.keyHolderSet((HolderGetter)biomes, (ResourceKey[])new ResourceKey[]{Biomes.END_HIGHLANDS, Biomes.END_MIDLANDS, Biomes.END_BARRENS, Biomes.SMALL_END_ISLANDS}), LimaRegistryUtil.keyHolderSet((HolderGetter)placements, (ResourceKey[])new ResourceKey[]{LTXIPlacedFeatures.NIOBIUM_ORE_PLACEMENT, LTXIPlacedFeatures.NIOBIUM_CLUSTERS_PLACEMENT}), GenerationStep.Decoration.UNDERGROUND_ORES);
        BiomeModifiers.AddFeaturesBiomeModifier basaltDeltas = new BiomeModifiers.AddFeaturesBiomeModifier(LimaRegistryUtil.keyHolderSet((HolderGetter)biomes, (ResourceKey)Biomes.BASALT_DELTAS), LimaRegistryUtil.keyHolderSet((HolderGetter)placements, LTXIPlacedFeatures.TITANIUM_CLUSTERS_PLACEMENT), GenerationStep.Decoration.UNDERGROUND_ORES);
        BiomeModifiers.AddFeaturesBiomeModifier sparkFruits = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_JUNGLE), LimaRegistryUtil.keyHolderSet((HolderGetter)placements, LTXIPlacedFeatures.SPARK_FRUIT_PLACEMENT), GenerationStep.Decoration.VEGETAL_DECORATION);
        BiomeModifiers.AddFeaturesBiomeModifier bilevine = new BiomeModifiers.AddFeaturesBiomeModifier((HolderSet)biomes.getOrThrow(BiomeTags.IS_NETHER), LimaRegistryUtil.keyHolderSet((HolderGetter)placements, (ResourceKey[])new ResourceKey[]{LTXIPlacedFeatures.FORTRESS_BILEVINE, LTXIPlacedFeatures.BASTION_BILEVINE}), GenerationStep.Decoration.VEGETAL_DECORATION);
        BiomeModifiers.AddFeaturesBiomeModifier gloomShrooms = new BiomeModifiers.AddFeaturesBiomeModifier(LimaRegistryUtil.keyHolderSet((HolderGetter)biomes, (ResourceKey)Biomes.DEEP_DARK), LimaRegistryUtil.keyHolderSet((HolderGetter)placements, LTXIPlacedFeatures.GLOOM_SHROOM_PLACEMENT), GenerationStep.Decoration.VEGETAL_DECORATION);
        context.register(OVERWORLD_ORES, (Object)titaniumOre);
        context.register(BASALT_DELTA_ORES, (Object)basaltDeltas);
        context.register(OUTER_END_ORES, (Object)niobiumOre);
        context.register(JUNGLE_VEGETATION, (Object)sparkFruits);
        context.register(NETHER_VEGETATION, (Object)bilevine);
        context.register(DEEP_DARK_VEGETATION, (Object)gloomShrooms);
    }
}

