/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.bootstrap;

import java.util.List;
import liedge.limacore.data.generation.LimaBootstrapUtil;
import liedge.limacore.world.generation.PlaceOnSideFeature;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.block.BerryVinesBlock;
import liedge.ltxindustries.block.BerryVinesPlantBlock;
import liedge.ltxindustries.registry.game.LTXIBlocks;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CaveVines;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockColumnConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.RandomizedIntStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public final class LTXIConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> TITANIUM_ORE_CONFIG = LTXIConfiguredFeatures.key("titanium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIOBIUM_ORE_CONFIG = LTXIConfiguredFeatures.key("niobium_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TITANIUM_CLUSTERS_CONFIG = LTXIConfiguredFeatures.key("titanium_clusters");
    public static final ResourceKey<ConfiguredFeature<?, ?>> NIOBIUM_CLUSTERS_CONFIG = LTXIConfiguredFeatures.key("niobium_clusters");
    public static final ResourceKey<ConfiguredFeature<?, ?>> SPARK_FRUIT_CONFIG = LTXIConfiguredFeatures.key("jungle_spark_fruits");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BILEVINE_CONFIG = LTXIConfiguredFeatures.key("bilevine");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GLOOM_SHROOM_CONFIG = LTXIConfiguredFeatures.key("underground_gloom_shrooms");

    private LTXIConfiguredFeatures() {
    }

    private static ResourceKey<ConfiguredFeature<?, ?>> key(String name) {
        return LTXIndustries.RESOURCES.resourceKey(Registries.CONFIGURED_FEATURE, name);
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        ConfiguredFeature titaniumOre = new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)LimaBootstrapUtil.oreConfig((int)10, (OreConfiguration.TargetBlockState[])new OreConfiguration.TargetBlockState[]{LimaBootstrapUtil.tagMatchOreTarget((TagKey)BlockTags.STONE_ORE_REPLACEABLES, LTXIBlocks.TITANIUM_ORE), LimaBootstrapUtil.tagMatchOreTarget((TagKey)BlockTags.DEEPSLATE_ORE_REPLACEABLES, LTXIBlocks.DEEPSLATE_TITANIUM_ORE)}));
        ConfiguredFeature niobiumOre = new ConfiguredFeature(Feature.ORE, (FeatureConfiguration)LimaBootstrapUtil.oreConfig((int)3, (OreConfiguration.TargetBlockState[])new OreConfiguration.TargetBlockState[]{LimaBootstrapUtil.singleBlockOreTarget((Block)Blocks.END_STONE, LTXIBlocks.NIOBIUM_ORE)}));
        ConfiguredFeature titaniumClusters = PlaceOnSideFeature.placeOnSide((BlockStateProvider)LimaBootstrapUtil.simpleState(LTXIBlocks.RAW_TITANIUM_CLUSTER), (Direction)Direction.UP);
        ConfiguredFeature niobiumClusters = PlaceOnSideFeature.placeOnAnySide((BlockStateProvider)LimaBootstrapUtil.simpleState(LTXIBlocks.RAW_NIOBIUM_CLUSTER));
        ConfiguredFeature sparkFruits = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)new RandomizedIntStateProvider((BlockStateProvider)BlockStateProvider.simple((Block)((Block)LTXIBlocks.SPARK_FRUIT.get())), BlockStateProperties.AGE_2, (IntProvider)UniformInt.of((int)0, (int)2))));
        BlockState bilevineState = ((BerryVinesBlock)((Object)LTXIBlocks.BILEVINE.get())).defaultBlockState();
        BlockState bilevinePlantState = ((BerryVinesPlantBlock)((Object)LTXIBlocks.BILEVINE_PLANT.get())).defaultBlockState();
        WeightedStateProvider bilevinePlantProvider = new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)bilevinePlantState, 5).add((Object)((BlockState)bilevinePlantState.setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.valueOf(true))), 1));
        RandomizedIntStateProvider bilevineProvider = new RandomizedIntStateProvider((BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.builder().add((Object)bilevineState, 5).add((Object)((BlockState)bilevineState.setValue((Property)CaveVines.BERRIES, (Comparable)Boolean.valueOf(true))), 1)), BlockStateProperties.AGE_25, (IntProvider)UniformInt.of((int)23, (int)25));
        ConfiguredFeature bilevine = new ConfiguredFeature(Feature.BLOCK_COLUMN, (FeatureConfiguration)new BlockColumnConfiguration(List.of(BlockColumnConfiguration.layer((IntProvider)UniformInt.of((int)0, (int)7), (BlockStateProvider)bilevinePlantProvider), BlockColumnConfiguration.layer((IntProvider)ConstantInt.of((int)1), (BlockStateProvider)bilevineProvider)), Direction.DOWN, BlockPredicate.ONLY_IN_AIR_PREDICATE, true));
        ConfiguredFeature gloomShroom = new ConfiguredFeature(Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.simple((Block)((Block)LTXIBlocks.GLOOM_SHROOM.get()))));
        context.register(TITANIUM_ORE_CONFIG, (Object)titaniumOre);
        context.register(NIOBIUM_ORE_CONFIG, (Object)niobiumOre);
        context.register(TITANIUM_CLUSTERS_CONFIG, (Object)titaniumClusters);
        context.register(NIOBIUM_CLUSTERS_CONFIG, (Object)niobiumClusters);
        context.register(SPARK_FRUIT_CONFIG, (Object)sparkFruits);
        context.register(BILEVINE_CONFIG, (Object)bilevine);
        context.register(GLOOM_SHROOM_CONFIG, (Object)gloomShroom);
    }
}

