/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.bootstrap;

import java.util.Optional;
import liedge.limacore.lib.MobHostility;
import liedge.limacore.lib.damage.DamageReductionType;
import liedge.limacore.lib.math.CompareOperation;
import liedge.limacore.lib.math.MathOperation;
import liedge.limacore.registry.game.LimaCoreAttributes;
import liedge.limacore.world.loot.condition.EntityHostilityLootCondition;
import liedge.limacore.world.loot.condition.NumberComparisonLootCondition;
import liedge.limacore.world.loot.number.EntityAttributeValueProvider;
import liedge.limacore.world.loot.number.MathOpsNumberProvider;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.data.generation.LTXIBootstrapUtil;
import liedge.ltxindustries.lib.upgrades.UpgradeIcon;
import liedge.ltxindustries.lib.upgrades.effect.DirectDropsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.EnchantmentLevelsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.MiningRuleUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.ModifyReductionsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.PreventVibrationUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.BubbleShieldUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.DynamicDamageTagUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.entity.MobEffectUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.value.DoubleLevelBasedValue;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.equipment.EquipmentUpgrade;
import liedge.ltxindustries.lib.upgrades.tooltip.TooltipArgument;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltip;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueArgument;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueFormat;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueSentiment;
import liedge.ltxindustries.lib.weapons.GrenadeType;
import liedge.ltxindustries.lib.weapons.WeaponReloadSource;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.bootstrap.LTXIEnchantments;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;

public final class LTXIEquipmentUpgrades {
    public static final ResourceKey<EquipmentUpgrade> LTX_SHOVEL_DEFAULT = LTXIEquipmentUpgrades.key("default/ltx_shovel");
    public static final ResourceKey<EquipmentUpgrade> LTX_WRENCH_DEFAULT = LTXIEquipmentUpgrades.key("default/ltx_wrench");
    public static final ResourceKey<EquipmentUpgrade> LTX_MELEE_DEFAULT = LTXIEquipmentUpgrades.key("default/ltx_melee");
    public static final ResourceKey<EquipmentUpgrade> GLOWSTICK_LAUNCHER_DEFAULT = LTXIEquipmentUpgrades.key("default/glowstick_launcher");
    public static final ResourceKey<EquipmentUpgrade> SUBMACHINE_GUN_DEFAULT = LTXIEquipmentUpgrades.key("default/submachine_gun");
    public static final ResourceKey<EquipmentUpgrade> SHOTGUN_DEFAULT = LTXIEquipmentUpgrades.key("default/shotgun");
    public static final ResourceKey<EquipmentUpgrade> LFR_DEFAULT = LTXIEquipmentUpgrades.key("default/linear_fusion_rifle");
    public static final ResourceKey<EquipmentUpgrade> TOOL_ENERGY_UPGRADE = LTXIEquipmentUpgrades.key("tool_energy_upgrade");
    public static final ResourceKey<EquipmentUpgrade> EPSILON_FISHING_LURE = LTXIEquipmentUpgrades.key("epsilon_fishing_lure");
    public static final ResourceKey<EquipmentUpgrade> TOOL_NETHERITE_LEVEL = LTXIEquipmentUpgrades.key("tool_netherite_level");
    public static final ResourceKey<EquipmentUpgrade> EPSILON_OMNI_DRILL = LTXIEquipmentUpgrades.key("epsilon_omni_drill");
    public static final ResourceKey<EquipmentUpgrade> TOOL_VIBRATION_CANCEL = LTXIEquipmentUpgrades.key("tool_vibration_cancel");
    public static final ResourceKey<EquipmentUpgrade> TOOL_DIRECT_DROPS = LTXIEquipmentUpgrades.key("tool_direct_drops");
    public static final ResourceKey<EquipmentUpgrade> WEAPON_VIBRATION_CANCEL = LTXIEquipmentUpgrades.key("weapon_vibration_cancel");
    public static final ResourceKey<EquipmentUpgrade> WEAPON_DIRECT_DROPS = LTXIEquipmentUpgrades.key("weapon_direct_drops");
    public static final ResourceKey<EquipmentUpgrade> WEAPON_ARMOR_PIERCE = LTXIEquipmentUpgrades.key("weapon_armor_pierce");
    public static final ResourceKey<EquipmentUpgrade> LIGHTWEIGHT_ENERGY_ADAPTER = LTXIEquipmentUpgrades.key("lightweight_energy_adapter");
    public static final ResourceKey<EquipmentUpgrade> SPECIALIST_ENERGY_ADAPTER = LTXIEquipmentUpgrades.key("specialist_energy_adapter");
    public static final ResourceKey<EquipmentUpgrade> EXPLOSIVES_ENERGY_ADAPTER = LTXIEquipmentUpgrades.key("explosives_energy_adapter");
    public static final ResourceKey<EquipmentUpgrade> HEAVY_ENERGY_ADAPTER = LTXIEquipmentUpgrades.key("heavy_energy_adapter");
    public static final ResourceKey<EquipmentUpgrade> UNIVERSAL_INFINITE_AMMO = LTXIEquipmentUpgrades.key("universal_infinite_ammo");
    public static final ResourceKey<EquipmentUpgrade> UNIVERSAL_STEALTH_DAMAGE = LTXIEquipmentUpgrades.key("universal_stealth_damage");
    public static final ResourceKey<EquipmentUpgrade> NEUTRAL_ENEMY_TARGET_FILTER = LTXIEquipmentUpgrades.key("target_filter/neutral_enemy");
    public static final ResourceKey<EquipmentUpgrade> HOSTILE_TARGET_FILTER = LTXIEquipmentUpgrades.key("target_filter/hostile");
    public static final ResourceKey<EquipmentUpgrade> WEAPON_SHIELD_REGEN = LTXIEquipmentUpgrades.key("weapon_shield_regen");
    public static final ResourceKey<EquipmentUpgrade> HIGH_IMPACT_ROUNDS = LTXIEquipmentUpgrades.key("high_impact_rounds");
    public static final ResourceKey<EquipmentUpgrade> HEAVY_PISTOL_GOD_ROUNDS = LTXIEquipmentUpgrades.key("heavy_pistol_god_rounds");
    public static final ResourceKey<EquipmentUpgrade> GRENADE_LAUNCHER_PROJECTILE_SPEED = LTXIEquipmentUpgrades.key("grenade_launcher_projectile_speed");
    public static final ResourceKey<EquipmentUpgrade> EFFICIENCY_ENCHANTMENT = LTXIEquipmentUpgrades.key("enchantment/efficiency");
    public static final ResourceKey<EquipmentUpgrade> SILK_TOUCH_ENCHANTMENT = LTXIEquipmentUpgrades.key("enchantment/silk_touch");
    public static final ResourceKey<EquipmentUpgrade> FORTUNE_ENCHANTMENT = LTXIEquipmentUpgrades.key("enchantment/fortune");
    public static final ResourceKey<EquipmentUpgrade> LOOTING_ENCHANTMENT = LTXIEquipmentUpgrades.key("enchantment/looting");
    public static final ResourceKey<EquipmentUpgrade> AMMO_SCAVENGER_ENCHANTMENT = LTXIEquipmentUpgrades.key("enchantment/ammo_scavenger");
    public static final ResourceKey<EquipmentUpgrade> RAZOR_ENCHANTMENT = LTXIEquipmentUpgrades.key("enchantment/razor");
    public static final ResourceKey<EquipmentUpgrade> FLAME_GRENADE_CORE = LTXIEquipmentUpgrades.key("flame_grenade_core");
    public static final ResourceKey<EquipmentUpgrade> CRYO_GRENADE_CORE = LTXIEquipmentUpgrades.key("cryo_grenade_core");
    public static final ResourceKey<EquipmentUpgrade> ELECTRIC_GRENADE_CORE = LTXIEquipmentUpgrades.key("electric_grenade_core");
    public static final ResourceKey<EquipmentUpgrade> ACID_GRENADE_CORE = LTXIEquipmentUpgrades.key("acid_grenade_core");
    public static final ResourceKey<EquipmentUpgrade> NEURO_GRENADE_CORE = LTXIEquipmentUpgrades.key("neuro_grenade_core");
    public static final ResourceKey<EquipmentUpgrade> OMNI_GRENADE_CORE = LTXIEquipmentUpgrades.key("omni_grenade_core");

    private LTXIEquipmentUpgrades() {
    }

    private static ResourceKey<EquipmentUpgrade> key(String name) {
        return LTXIndustries.RESOURCES.resourceKey(LTXIRegistries.Keys.EQUIPMENT_UPGRADES, name);
    }

    public static void bootstrap(BootstrapContext<EquipmentUpgrade> context) {
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter gameEvents = context.lookup(Registries.GAME_EVENT);
        HolderGetter holders = context.lookup(LTXIRegistries.Keys.EQUIPMENT_UPGRADES);
        AnyHolderSet anyBlockHolderSet = new AnyHolderSet(BuiltInRegistries.BLOCK.asLookup());
        AnyHolderSet anyItemHolderSet = new AnyHolderSet(BuiltInRegistries.ITEM.asLookup());
        HolderSet.Named ltxAllTools = items.getOrThrow(LTXITags.Items.ALL_TOOLS);
        HolderSet.Named ltxMiningTools = items.getOrThrow(LTXITags.Items.MINING_TOOLS);
        HolderSet.Named ltxProjectileWeapons = items.getOrThrow(LTXITags.Items.ENERGY_PROJECTILE_WEAPONS);
        HolderSet.Named ltxAllWeapons = items.getOrThrow(LTXITags.Items.ALL_WEAPONS);
        MutableComponent defaultToolTitle = LTXILangKeys.TOOL_DEFAULT_UPGRADE_TITLE.translate().withStyle(LTXIConstants.LIME_GREEN.chatStyle());
        EquipmentUpgrade.builder(LTX_SHOVEL_DEFAULT).setTitle((Component)defaultToolTitle).supports((Holder<Item>)LTXIItems.LTX_SHOVEL).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.fixed((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.SILK_TOUCH), 1)).effectIcon(LTXIBootstrapUtil.defaultModuleIcon(LTXIItems.LTX_SHOVEL)).category("default/tool").register(context);
        EquipmentUpgrade.builder(LTX_WRENCH_DEFAULT).setTitle((Component)defaultToolTitle).supports((Holder<Item>)LTXIItems.LTX_WRENCH).withEffect(LTXIUpgradeEffectComponents.DIRECT_DROPS, DirectDropsUpgradeEffect.blocksOnly((HolderSet<Item>)items.getOrThrow(LTXITags.Items.WRENCH_BREAKABLE))).effectIcon(LTXIBootstrapUtil.defaultModuleIcon(LTXIItems.LTX_WRENCH)).category("default/tool").register(context);
        EquipmentUpgrade.builder(LTX_MELEE_DEFAULT).setTitle((Component)defaultToolTitle).supports((HolderSet<Item>)items.getOrThrow(LTXITags.Items.MELEE_WEAPONS)).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.fixed((Holder<Enchantment>)enchantments.getOrThrow(LTXIEnchantments.RAZOR), 1, 5)).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.fixed((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.LOOTING), 1, 5)).withConditionalEffect(LTXIUpgradeEffectComponents.EQUIPMENT_DAMAGE, ValueUpgradeEffect.of(DoubleLevelBasedValue.constant(0.2), MathOperation.ADD_PERCENT_OF_TOTAL), NumberComparisonLootCondition.comparingValues((NumberProvider)EntityAttributeValueProvider.totalValue((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (Holder)Attributes.ARMOR), (NumberProvider)EntityAttributeValueProvider.baseValue((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (Holder)Attributes.ARMOR), (CompareOperation)CompareOperation.LESS_THAN_OR_EQUALS)).tooltip(0, key -> UpgradeTooltip.of(key, ValueArgument.of(DoubleLevelBasedValue.constant(0.2), ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE))).effectIcon(LTXIBootstrapUtil.bottomRightComposite(UpgradeIcon.sprite("razor"), UpgradeIcon.sprite("default_overlay"), 7)).category("default/tool").register(context);
        DoubleLevelBasedValue.ConstantValue gslEnergyCap = DoubleLevelBasedValue.constant(50000.0);
        DoubleLevelBasedValue.ConstantValue gslEnergyUse = DoubleLevelBasedValue.constant(5000.0);
        EquipmentUpgrade.builder(GLOWSTICK_LAUNCHER_DEFAULT).supports((Holder<Item>)LTXIItems.GLOWSTICK_LAUNCHER).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.AMMO_SOURCE_MODIFIERS).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(gslEnergyCap, MathOperation.REPLACE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(gslEnergyUse, MathOperation.REPLACE)).withSpecialEffect(LTXIUpgradeEffectComponents.RELOAD_SOURCE, WeaponReloadSource.commonEnergy()).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(gslEnergyCap, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(gslEnergyUse, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).effectIcon(LTXIBootstrapUtil.defaultModuleIcon(LTXIItems.GLOWSTICK_LAUNCHER)).category("default/weapon").register(context);
        EquipmentUpgrade.builder(SUBMACHINE_GUN_DEFAULT).supports((Holder<Item>)LTXIItems.SUBMACHINE_GUN).withEffect(LTXIUpgradeEffectComponents.PREVENT_VIBRATION, PreventVibrationUpgradeEffect.suppressMainHand((HolderSet<GameEvent>)gameEvents.getOrThrow(LTXITags.GameEvents.WEAPON_VIBRATIONS))).withTargetedEffect(LTXIUpgradeEffectComponents.EQUIPMENT_PRE_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, DynamicDamageTagUpgradeEffect.of(DamageTypeTags.NO_ANGER, DamageTypeTags.NO_KNOCKBACK)).effectIcon(LTXIBootstrapUtil.defaultModuleIcon(LTXIItems.SUBMACHINE_GUN)).category("default/weapon").register(context);
        EquipmentUpgrade.builder(SHOTGUN_DEFAULT).supports((Holder<Item>)LTXIItems.SHOTGUN).itemAttributes((Holder<Attribute>)Attributes.MOVEMENT_SPEED, "speed", (LevelBasedValue)LevelBasedValue.constant((float)0.25f), AttributeModifier.Operation.ADD_MULTIPLIED_BASE, EquipmentSlotGroup.MAINHAND).itemAttributes((Holder<Attribute>)Attributes.STEP_HEIGHT, "step_height", (LevelBasedValue)LevelBasedValue.constant((float)1.0f), AttributeModifier.Operation.ADD_VALUE, EquipmentSlotGroup.MAINHAND).itemAttributes((Holder<Attribute>)Attributes.SAFE_FALL_DISTANCE, "safe_fall_dist", (LevelBasedValue)LevelBasedValue.constant((float)3.0f), AttributeModifier.Operation.ADD_VALUE, EquipmentSlotGroup.MAINHAND).withEffect(LTXIUpgradeEffectComponents.DAMAGE_REDUCTION_MODIFIER, new ModifyReductionsUpgradeEffect(DamageReductionType.ARMOR, (LevelBasedValue)LevelBasedValue.constant((float)-0.1f))).effectIcon(LTXIBootstrapUtil.defaultModuleIcon(LTXIItems.SHOTGUN)).category("default/weapon").register(context);
        EquipmentUpgrade.builder(LFR_DEFAULT).supports((Holder<Item>)LTXIItems.LINEAR_FUSION_RIFLE).withConditionalEffect(LTXIUpgradeEffectComponents.EQUIPMENT_DAMAGE, ValueUpgradeEffect.of(DoubleLevelBasedValue.constant(25.0), MathOperation.ADD), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().distance(DistancePredicate.absolute((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atLeast((double)40.0))))).withConditionalEffect(LTXIUpgradeEffectComponents.EQUIPMENT_DAMAGE, ValueUpgradeEffect.of(DoubleLevelBasedValue.constant(0.25), MathOperation.ADD_PERCENT_OF_TOTAL), LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.ATTACKER, (EntityPredicate.Builder)EntityPredicate.Builder.entity().moving(MovementPredicate.speed((MinMaxBounds.Doubles)MinMaxBounds.Doubles.atMost((double)0.001))).flags(EntityFlagsPredicate.Builder.flags().setCrouching(Boolean.valueOf(true))))).tooltip(0, key -> UpgradeTooltip.of(key, ValueArgument.of(DoubleLevelBasedValue.constant(25.0), ValueFormat.SIGNED_FLAT_NUMBER, ValueSentiment.POSITIVE))).tooltip(1, key -> UpgradeTooltip.of(key, ValueArgument.of(DoubleLevelBasedValue.constant(0.25), ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE))).effectIcon(LTXIBootstrapUtil.defaultModuleIcon(LTXIItems.LINEAR_FUSION_RIFLE)).category("default/weapon").register(context);
        DoubleLevelBasedValue.Exponential toolEnergy = DoubleLevelBasedValue.exponential(2.0, DoubleLevelBasedValue.linear(2.0, 1.0));
        EquipmentUpgrade.builder(TOOL_ENERGY_UPGRADE).createDefaultTitle(LTXIConstants.REM_BLUE).supports((HolderSet<Item>)ltxAllTools).setMaxRank(4).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(toolEnergy, MathOperation.MULTIPLY)).withEffect(LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, ValueUpgradeEffect.of(toolEnergy, MathOperation.MULTIPLY)).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(toolEnergy, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyTransferTooltip(toolEnergy, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).effectIcon(UpgradeIcon.sprite("extra_energy")).category("tools").register(context);
        EquipmentUpgrade.builder(EPSILON_FISHING_LURE).createDefaultTitle(LTXIConstants.LIME_GREEN).supports((Holder<Item>)LTXIItems.LTX_FISHING_ROD).setMaxRank(5).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.LURE))).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.LUCK_OF_THE_SEA))).effectIcon(LTXIBootstrapUtil.bottomRightComposite(UpgradeIcon.itemIcon(LTXIItems.LTX_FISHING_ROD), UpgradeIcon.sprite("plus_overlay"), 9)).category("tools").register(context);
        EquipmentUpgrade.builder(TOOL_NETHERITE_LEVEL).supports((HolderSet<Item>)ltxMiningTools).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.MINING_LEVEL_UPGRADES).withEffect(LTXIUpgradeEffectComponents.MINING_RULES, MiningRuleUpgradeEffect.miningLevelAndSpeed((HolderSet<Block>)blocks.getOrThrow(BlockTags.INCORRECT_FOR_NETHERITE_TOOL), 11.0f, 2)).effectIcon(LTXIBootstrapUtil.bottomRightComposite(UpgradeIcon.itemIcon((ItemLike)Items.NETHERITE_PICKAXE), UpgradeIcon.sprite("green_arrow_overlay"), 9)).category("tools").register(context);
        EquipmentUpgrade.builder(EPSILON_OMNI_DRILL).createDefaultTitle(LTXIConstants.LIME_GREEN).supports((Holder<Item>)LTXIItems.LTX_DRILL).withEffect(LTXIUpgradeEffectComponents.MINING_RULES, new MiningRuleUpgradeEffect(Optional.of(anyBlockHolderSet), Optional.empty(), Optional.empty(), 3)).effectIcon(UpgradeIcon.sprite("purple_drill_head")).category("tools/drill").register(context);
        EquipmentUpgrade.builder(TOOL_VIBRATION_CANCEL).supports((HolderSet<Item>)items.getOrThrow(LTXITags.Items.ALL_TOOLS)).withEffect(LTXIUpgradeEffectComponents.PREVENT_VIBRATION, PreventVibrationUpgradeEffect.suppressHands((HolderSet<GameEvent>)gameEvents.getOrThrow(LTXITags.GameEvents.HANDHELD_EQUIPMENT))).effectIcon(UpgradeIcon.sprite("earmuffs")).category("tools").register(context);
        EquipmentUpgrade.builder(TOOL_DIRECT_DROPS).supports((HolderSet<Item>)ltxMiningTools).withEffect(LTXIUpgradeEffectComponents.DIRECT_DROPS, DirectDropsUpgradeEffect.blocksOnly((HolderSet<Item>)anyItemHolderSet)).effectIcon(UpgradeIcon.sprite("magnet")).category("tools").register(context);
        EquipmentUpgrade.builder(HIGH_IMPACT_ROUNDS).supports(new Holder[]{LTXIItems.SHOTGUN, LTXIItems.HEAVY_PISTOL}).damageAttributes((Holder<Attribute>)Attributes.KNOCKBACK_RESISTANCE, "knockback_resistance", (LevelBasedValue)LevelBasedValue.constant((float)-1.0f), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL).damageAttributes((Holder<Attribute>)LimaCoreAttributes.KNOCKBACK_MULTIPLIER, "knockback", (LevelBasedValue)LevelBasedValue.constant((float)2.0f), AttributeModifier.Operation.ADD_VALUE).effectIcon(UpgradeIcon.sprite("powerful_lightfrag")).register(context);
        EquipmentUpgrade.builder(HEAVY_PISTOL_GOD_ROUNDS).supports((Holder<Item>)LTXIItems.HEAVY_PISTOL).withTargetedEffect(LTXIUpgradeEffectComponents.EQUIPMENT_PRE_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, DynamicDamageTagUpgradeEffect.of(LTXITags.DamageTypes.BYPASS_SURVIVAL_DEFENSES)).withConditionalEffect(LTXIUpgradeEffectComponents.EQUIPMENT_DAMAGE, ValueUpgradeEffect.of(MathOpsNumberProvider.of((NumberProvider)EntityAttributeValueProvider.totalValue((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (Holder)Attributes.MAX_HEALTH), (NumberProvider)ConstantValue.exactly((float)0.25f), (MathOperation)MathOperation.MULTIPLY), MathOperation.ADD)).tooltip(UpgradeTooltip.of(LTXILangKeys.ATTRIBUTE_SCALED_DAMAGE_UPGRADE, ValueArgument.of(DoubleLevelBasedValue.constant(0.25), ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE), TooltipArgument.of((Component)Component.translatable((String)((Attribute)Attributes.MAX_HEALTH.value()).getDescriptionId()).withStyle(ChatFormatting.DARK_RED)))).effectIcon(LTXIBootstrapUtil.spriteOverItemIcon(LTXIItems.HEAVY_PISTOL, "plus_overlay", 9)).register(context);
        EquipmentUpgrade.builder(GRENADE_LAUNCHER_PROJECTILE_SPEED).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).setMaxRank(2).withEffect(LTXIUpgradeEffectComponents.WEAPON_RANGE, ValueUpgradeEffect.of(DoubleLevelBasedValue.linear(0.5), MathOperation.ADD)).tooltip(UpgradeTooltip.of(LTXILangKeys.PROJECTILE_SPEED_UPGRADE, ValueArgument.of(DoubleLevelBasedValue.linear(0.5), ValueFormat.SIGNED_FLAT_NUMBER, ValueSentiment.POSITIVE))).effectIcon(UpgradeIcon.sprite("grenade_speed_boost")).register(context);
        EquipmentUpgrade.builder(WEAPON_VIBRATION_CANCEL).supports((HolderSet<Item>)ltxProjectileWeapons).withEffect(LTXIUpgradeEffectComponents.PREVENT_VIBRATION, PreventVibrationUpgradeEffect.suppressMainHand((HolderSet<GameEvent>)gameEvents.getOrThrow(LTXITags.GameEvents.WEAPON_VIBRATIONS))).effectIcon(UpgradeIcon.sprite("earmuffs")).register(context);
        EquipmentUpgrade.builder(UNIVERSAL_STEALTH_DAMAGE).supports((HolderSet<Item>)ltxProjectileWeapons).withTargetedEffect(LTXIUpgradeEffectComponents.EQUIPMENT_PRE_ATTACK, EnchantmentTarget.ATTACKER, EnchantmentTarget.VICTIM, DynamicDamageTagUpgradeEffect.of((TagKey<DamageType>)DamageTypeTags.NO_ANGER)).effectIcon(UpgradeIcon.sprite("stealth_damage")).register(context);
        EquipmentUpgrade.builder(WEAPON_DIRECT_DROPS).supports((HolderSet<Item>)ltxAllWeapons).withEffect(LTXIUpgradeEffectComponents.DIRECT_DROPS, DirectDropsUpgradeEffect.entityDrops((HolderSet<Item>)anyItemHolderSet)).effectIcon(UpgradeIcon.sprite("magnet")).register(context);
        EquipmentUpgrade.builder(WEAPON_ARMOR_PIERCE).supports((HolderSet<Item>)ltxProjectileWeapons).setMaxRank(3).withEffect(LTXIUpgradeEffectComponents.DAMAGE_REDUCTION_MODIFIER, new ModifyReductionsUpgradeEffect(DamageReductionType.ARMOR, (LevelBasedValue)LevelBasedValue.perLevel((float)-0.2f))).effectIcon(UpgradeIcon.sprite("broken_armor")).register(context);
        DoubleLevelBasedValue.ConstantValue lightweightEnergyCapacity = DoubleLevelBasedValue.constant(100000.0);
        DoubleLevelBasedValue.ConstantValue lightweightEnergyUsage = DoubleLevelBasedValue.constant(10000.0);
        EquipmentUpgrade.builder(LIGHTWEIGHT_ENERGY_ADAPTER).createDefaultTitle(LTXIConstants.REM_BLUE).supports((HolderGetter<Item>)items, LTXITags.Items.LIGHTWEIGHT_WEAPONS).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.AMMO_SOURCE_MODIFIERS).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(lightweightEnergyCapacity, MathOperation.REPLACE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(lightweightEnergyUsage, MathOperation.REPLACE)).withSpecialEffect(LTXIUpgradeEffectComponents.RELOAD_SOURCE, WeaponReloadSource.commonEnergy()).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(lightweightEnergyCapacity, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(lightweightEnergyUsage, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).effectIcon(UpgradeIcon.sprite(LIGHTWEIGHT_ENERGY_ADAPTER.location().getPath())).category("weapon/ammo").register(context);
        DoubleLevelBasedValue.ConstantValue specialistEnergyCapacity = DoubleLevelBasedValue.constant(5000000.0);
        DoubleLevelBasedValue.ConstantValue specialistEnergyUsage = DoubleLevelBasedValue.constant(1000000.0);
        EquipmentUpgrade.builder(SPECIALIST_ENERGY_ADAPTER).createDefaultTitle(LTXIConstants.REM_BLUE).supports((HolderGetter<Item>)items, LTXITags.Items.SPECIALIST_WEAPONS).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.AMMO_SOURCE_MODIFIERS).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(specialistEnergyCapacity, MathOperation.REPLACE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(specialistEnergyUsage, MathOperation.REPLACE)).withSpecialEffect(LTXIUpgradeEffectComponents.RELOAD_SOURCE, WeaponReloadSource.commonEnergy()).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(specialistEnergyCapacity, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(specialistEnergyUsage, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).effectIcon(UpgradeIcon.sprite(SPECIALIST_ENERGY_ADAPTER.location().getPath())).category("weapon/ammo").register(context);
        DoubleLevelBasedValue.ConstantValue explosivesEnergyCapacity = DoubleLevelBasedValue.constant(2.0E7);
        DoubleLevelBasedValue.ConstantValue explosivesEnergyUsage = DoubleLevelBasedValue.constant(1.0E7);
        EquipmentUpgrade.builder(EXPLOSIVES_ENERGY_ADAPTER).createDefaultTitle(LTXIConstants.REM_BLUE).supports((HolderGetter<Item>)items, LTXITags.Items.EXPLOSIVE_WEAPONS).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.AMMO_SOURCE_MODIFIERS).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(explosivesEnergyCapacity, MathOperation.REPLACE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(explosivesEnergyUsage, MathOperation.REPLACE)).withSpecialEffect(LTXIUpgradeEffectComponents.RELOAD_SOURCE, WeaponReloadSource.commonEnergy()).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(explosivesEnergyCapacity, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(explosivesEnergyUsage, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).effectIcon(UpgradeIcon.sprite(EXPLOSIVES_ENERGY_ADAPTER.location().getPath())).category("weapon/ammo").register(context);
        DoubleLevelBasedValue.ConstantValue heavyEnergyCapacity = DoubleLevelBasedValue.constant(5.0E7);
        DoubleLevelBasedValue.ConstantValue heavyEnergyUsage = DoubleLevelBasedValue.constant(2.5E7);
        EquipmentUpgrade.builder(HEAVY_ENERGY_ADAPTER).createDefaultTitle(LTXIConstants.REM_BLUE).supports((HolderGetter<Item>)items, LTXITags.Items.HEAVY_WEAPONS).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.AMMO_SOURCE_MODIFIERS).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(heavyEnergyCapacity, MathOperation.REPLACE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(heavyEnergyUsage, MathOperation.REPLACE)).withSpecialEffect(LTXIUpgradeEffectComponents.RELOAD_SOURCE, WeaponReloadSource.commonEnergy()).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(heavyEnergyCapacity, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(heavyEnergyUsage, ValueFormat.FLAT_NUMBER, ValueSentiment.NEUTRAL)).effectIcon(UpgradeIcon.sprite(HEAVY_ENERGY_ADAPTER.location().getPath())).category("weapon/ammo").register(context);
        EquipmentUpgrade.builder(UNIVERSAL_INFINITE_AMMO).createDefaultTitle(LTXIConstants.CREATIVE_PINK).supports((HolderSet<Item>)ltxProjectileWeapons).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.AMMO_SOURCE_MODIFIERS).withSpecialEffect(LTXIUpgradeEffectComponents.RELOAD_SOURCE, WeaponReloadSource.infiniteAmmo()).effectIcon(UpgradeIcon.sprite("infinite_ammo")).category("weapon/ammo").register(context);
        EquipmentUpgrade.builder(NEUTRAL_ENEMY_TARGET_FILTER).createDefaultTitle(LTXIConstants.HOSTILE_ORANGE).supports((HolderSet<Item>)ltxAllWeapons).withEffect(LTXIUpgradeEffectComponents.TARGET_CONDITIONS, EntityHostilityLootCondition.atLeast((MobHostility)MobHostility.NEUTRAL_ENEMY).build()).effectIcon(UpgradeIcon.sprite("neutral_enemy_targets")).category("target_filters").register(context);
        EquipmentUpgrade.builder(HOSTILE_TARGET_FILTER).createDefaultTitle(LTXIConstants.HOSTILE_ORANGE).supports((HolderSet<Item>)ltxAllWeapons).withEffect(LTXIUpgradeEffectComponents.TARGET_CONDITIONS, EntityHostilityLootCondition.atLeast((MobHostility)MobHostility.HOSTILE).build()).effectIcon(UpgradeIcon.sprite("hostile_targets")).category("target_filters").register(context);
        EquipmentUpgrade.builder(WEAPON_SHIELD_REGEN).supports((HolderSet<Item>)ltxProjectileWeapons).setMaxRank(3).withTargetedEffect(LTXIUpgradeEffectComponents.EQUIPMENT_KILL, EnchantmentTarget.ATTACKER, EnchantmentTarget.ATTACKER, new BubbleShieldUpgradeEffect((LevelBasedValue)LevelBasedValue.constant((float)4.0f), (LevelBasedValue)LevelBasedValue.perLevel((float)10.0f))).withTargetedEffect(LTXIUpgradeEffectComponents.EQUIPMENT_KILL, EnchantmentTarget.ATTACKER, EnchantmentTarget.ATTACKER, MobEffectUpgradeEffect.create((Holder<MobEffect>)MobEffects.REGENERATION, (LevelBasedValue)LevelBasedValue.constant((float)60.0f))).effectIcon(UpgradeIcon.sprite("bubble_shield")).register(context);
        EquipmentUpgrade.builder(EFFICIENCY_ENCHANTMENT).supports((HolderSet<Item>)ltxMiningTools).setMaxRank(5).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.EFFICIENCY))).effectIcon(LTXIBootstrapUtil.bottomRightComposite(UpgradeIcon.itemIcon(LTXIItems.LTX_DRILL), UpgradeIcon.sprite("yellow_arrow_overlay"), 9)).category("enchants").register(context);
        EquipmentUpgrade.builder(SILK_TOUCH_ENCHANTMENT).supports((HolderSet<Item>)ltxMiningTools).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.MINING_DROPS_MODIFIERS).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.fixed((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.SILK_TOUCH), 1)).effectIcon(LTXIBootstrapUtil.bottomRightComposite(UpgradeIcon.itemIcon(LTXIItems.LTX_DRILL), UpgradeIcon.sprite("silk_overlay"), 8)).category("enchants").register(context);
        EquipmentUpgrade.builder(FORTUNE_ENCHANTMENT).supports((HolderSet<Item>)ltxMiningTools).exclusiveWith((HolderGetter<EquipmentUpgrade>)holders, LTXITags.EquipmentUpgrades.MINING_DROPS_MODIFIERS).setMaxRank(5).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.FORTUNE))).effectIcon(LTXIBootstrapUtil.luckOverlayIcon(LTXIItems.LTX_DRILL)).category("enchants").register(context);
        EquipmentUpgrade.builder(LOOTING_ENCHANTMENT).supports((HolderSet<Item>)ltxAllWeapons).setMaxRank(5).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.LOOTING))).effectIcon(LTXIBootstrapUtil.luckOverlayIcon(LTXIItems.LTX_SWORD)).category("enchants").register(context);
        EquipmentUpgrade.builder(AMMO_SCAVENGER_ENCHANTMENT).supports((HolderSet<Item>)ltxAllWeapons).setMaxRank(5).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(LTXIEnchantments.AMMO_SCAVENGER))).effectIcon(UpgradeIcon.sprite("ammo_scavenger")).category("enchants").register(context);
        EquipmentUpgrade.builder(RAZOR_ENCHANTMENT).supports((HolderSet<Item>)ltxAllWeapons).setMaxRank(5).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(LTXIEnchantments.RAZOR))).effectIcon(UpgradeIcon.sprite("razor")).category("enchants").register(context);
        EquipmentUpgrade.builder(FLAME_GRENADE_CORE).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.FLAME).effectIcon(UpgradeIcon.sprite("flame_grenade_core")).category("grenade_cores").register(context);
        EquipmentUpgrade.builder(CRYO_GRENADE_CORE).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.CRYO).effectIcon(UpgradeIcon.sprite("cryo_grenade_core")).category("grenade_cores").register(context);
        EquipmentUpgrade.builder(ELECTRIC_GRENADE_CORE).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.ELECTRIC).effectIcon(UpgradeIcon.sprite("electric_grenade_core")).category("grenade_cores").register(context);
        EquipmentUpgrade.builder(ACID_GRENADE_CORE).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.ACID).effectIcon(UpgradeIcon.sprite("acid_grenade_core")).category("grenade_cores").register(context);
        EquipmentUpgrade.builder(NEURO_GRENADE_CORE).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.NEURO).effectIcon(UpgradeIcon.sprite("neuro_grenade_core")).category("grenade_cores").register(context);
        EquipmentUpgrade.builder(OMNI_GRENADE_CORE).supports((Holder<Item>)LTXIItems.GRENADE_LAUNCHER).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.FLAME).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.CRYO).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.ELECTRIC).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.ACID).withEffect(LTXIUpgradeEffectComponents.GRENADE_UNLOCK, GrenadeType.NEURO).effectIcon(UpgradeIcon.sprite("omni_grenade_core")).category("grenade_cores").register(context);
    }
}

