/*
 * Decompiled with CFR 0.152.
 */
package liedge.ltxindustries.registry.bootstrap;

import liedge.limacore.lib.math.MathOperation;
import liedge.ltxindustries.LTXIConstants;
import liedge.ltxindustries.LTXITags;
import liedge.ltxindustries.LTXIndustries;
import liedge.ltxindustries.client.LTXILangKeys;
import liedge.ltxindustries.data.generation.LTXIBootstrapUtil;
import liedge.ltxindustries.lib.upgrades.UpgradeIcon;
import liedge.ltxindustries.lib.upgrades.effect.DirectDropsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.EnchantmentLevelsUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.MinimumSpeedUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.effect.value.DoubleLevelBasedValue;
import liedge.ltxindustries.lib.upgrades.effect.value.ValueUpgradeEffect;
import liedge.ltxindustries.lib.upgrades.machine.MachineUpgrade;
import liedge.ltxindustries.lib.upgrades.tooltip.UpgradeTooltip;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueArgument;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueFormat;
import liedge.ltxindustries.lib.upgrades.tooltip.ValueSentiment;
import liedge.ltxindustries.registry.LTXIRegistries;
import liedge.ltxindustries.registry.bootstrap.LTXIEnchantments;
import liedge.ltxindustries.registry.game.LTXIBlockEntities;
import liedge.ltxindustries.registry.game.LTXIItems;
import liedge.ltxindustries.registry.game.LTXIUpgradeEffectComponents;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.neoforge.registries.holdersets.AnyHolderSet;

public final class LTXIMachineUpgrades {
    public static final ResourceKey<MachineUpgrade> ECA_CAPACITY_UPGRADE = LTXIMachineUpgrades.key("eca_capacity");
    public static final ResourceKey<MachineUpgrade> STANDARD_MACHINE_SYSTEMS = LTXIMachineUpgrades.key("standard_machine_systems");
    public static final ResourceKey<MachineUpgrade> ULTIMATE_MACHINE_SYSTEMS = LTXIMachineUpgrades.key("ultimate_machine_systems");
    public static final ResourceKey<MachineUpgrade> FABRICATOR_UPGRADE = LTXIMachineUpgrades.key("fabricator_upgrade");
    public static final ResourceKey<MachineUpgrade> TURRET_LOOTING = LTXIMachineUpgrades.key("turret_looting");
    public static final ResourceKey<MachineUpgrade> TURRET_RAZOR = LTXIMachineUpgrades.key("turret_razor");
    public static final ResourceKey<MachineUpgrade> TURRET_LOOT_COLLECTOR = LTXIMachineUpgrades.key("turret_loot_collector");

    private LTXIMachineUpgrades() {
    }

    private static ResourceKey<MachineUpgrade> key(String name) {
        return LTXIndustries.RESOURCES.resourceKey(LTXIRegistries.Keys.MACHINE_UPGRADES, name);
    }

    public static void bootstrap(BootstrapContext<MachineUpgrade> context) {
        HolderGetter holders = context.lookup(LTXIRegistries.Keys.MACHINE_UPGRADES);
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter blockEntities = context.lookup(Registries.BLOCK_ENTITY_TYPE);
        AnyHolderSet anyItemHolderSet = new AnyHolderSet(BuiltInRegistries.ITEM.asLookup());
        DoubleLevelBasedValue.Exponential ecaScaling = DoubleLevelBasedValue.exponential(2.0, DoubleLevelBasedValue.linear(3.0, 1.0));
        MachineUpgrade.builder(ECA_CAPACITY_UPGRADE).createDefaultTitle(LTXIConstants.REM_BLUE).supports((Holder<BlockEntityType<?>>)LTXIBlockEntities.ENERGY_CELL_ARRAY).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(ecaScaling, MathOperation.MULTIPLY)).withEffect(LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, ValueUpgradeEffect.of(ecaScaling, MathOperation.MULTIPLY)).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(ecaScaling, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyTransferTooltip(ecaScaling, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).setMaxRank(5).effectIcon(UpgradeIcon.sprite("extra_energy")).register(context);
        DoubleLevelBasedValue.LinearValue smsEnergyStorage = DoubleLevelBasedValue.linear(0.5);
        MachineUpgrade.builder(STANDARD_MACHINE_SYSTEMS).supports(blockEntities, LTXITags.BlockEntities.STANDARD_UPGRADABLE_MACHINES).exclusiveWith((HolderGetter<MachineUpgrade>)holders, LTXITags.MachineUpgrades.MACHINE_TIER).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(smsEnergyStorage, MathOperation.ADD_PERCENT_OF_BASE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, ValueUpgradeEffect.of(smsEnergyStorage, MathOperation.ADD_PERCENT_OF_BASE)).withEffect(LTXIUpgradeEffectComponents.TICKS_PER_OPERATION, ValueUpgradeEffect.of(DoubleLevelBasedValue.linearExponent(0.725), MathOperation.MULTIPLY)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(DoubleLevelBasedValue.linearExponent(1.5), MathOperation.MULTIPLY)).withSpecialEffect(LTXIUpgradeEffectComponents.MINIMUM_MACHINE_SPEED, MinimumSpeedUpgradeEffect.atLeast(5)).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(smsEnergyStorage, ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyTransferTooltip(smsEnergyStorage, ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(DoubleLevelBasedValue.linearExponent(1.5), ValueFormat.MULTIPLICATIVE, ValueSentiment.NEUTRAL)).tooltip(UpgradeTooltip.of(LTXILangKeys.MACHINE_SPEED_UPGRADE, ValueArgument.of(DoubleLevelBasedValue.linearExponent(0.725), ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE))).tooltip(UpgradeTooltip.of(LTXILangKeys.ENERGY_PER_RECIPE_UPGRADE, ValueArgument.of(DoubleLevelBasedValue.linearExponent(1.0875), ValueFormat.MULTIPLICATIVE, ValueSentiment.NEGATIVE))).setMaxRank(6).effectIcon(UpgradeIcon.sprite("standard_gear")).category("gpm").register(context);
        DoubleLevelBasedValue.ConstantValue umsEnergyStorage = DoubleLevelBasedValue.constant(16.0);
        DoubleLevelBasedValue.ConstantValue umsEnergyUsage = DoubleLevelBasedValue.constant(512.0);
        MachineUpgrade.builder(ULTIMATE_MACHINE_SYSTEMS).createDefaultTitle(LTXIConstants.LIME_GREEN).supports(blockEntities, LTXITags.BlockEntities.ULTIMATE_UPGRADABLE_MACHINES).exclusiveWith((HolderGetter<MachineUpgrade>)holders, LTXITags.MachineUpgrades.MACHINE_TIER).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(umsEnergyStorage, MathOperation.MULTIPLY)).withEffect(LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, ValueUpgradeEffect.of(umsEnergyStorage, MathOperation.MULTIPLY)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(umsEnergyUsage, MathOperation.MULTIPLY)).withEffect(LTXIUpgradeEffectComponents.TICKS_PER_OPERATION, ValueUpgradeEffect.of(DoubleLevelBasedValue.constant(0.0), MathOperation.MULTIPLY)).withSpecialEffect(LTXIUpgradeEffectComponents.MINIMUM_MACHINE_SPEED, MinimumSpeedUpgradeEffect.atLeast(0)).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(umsEnergyStorage, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyTransferTooltip(umsEnergyStorage, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(umsEnergyUsage, ValueFormat.MULTIPLICATIVE, ValueSentiment.NEGATIVE)).tooltip((Component)LTXILangKeys.INSTANT_PROCESSING_UPGRADE.translate().withStyle(LTXIConstants.LIME_GREEN.chatStyle())).effectIcon(UpgradeIcon.sprite("ultimate_gear")).category("gpm").register(context);
        DoubleLevelBasedValue.LinearValue fabCapacity = DoubleLevelBasedValue.linear(2.0);
        DoubleLevelBasedValue.LinearValue fabTransfer = DoubleLevelBasedValue.linear(3.0);
        DoubleLevelBasedValue.Exponential fabUsage = DoubleLevelBasedValue.exponential(2.0, DoubleLevelBasedValue.linear(2.0, 1.0));
        MachineUpgrade.builder(FABRICATOR_UPGRADE).supports(new Holder[]{LTXIBlockEntities.FABRICATOR, LTXIBlockEntities.AUTO_FABRICATOR}).withEffect(LTXIUpgradeEffectComponents.ENERGY_CAPACITY, ValueUpgradeEffect.of(fabCapacity, MathOperation.ADD_PERCENT_OF_BASE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_TRANSFER_RATE, ValueUpgradeEffect.of(fabTransfer, MathOperation.ADD_PERCENT_OF_BASE)).withEffect(LTXIUpgradeEffectComponents.ENERGY_USAGE, ValueUpgradeEffect.of(fabUsage, MathOperation.MULTIPLY)).tooltip(LTXIBootstrapUtil.energyCapacityTooltip(fabCapacity, ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyTransferTooltip(fabTransfer, ValueFormat.SIGNED_PERCENTAGE, ValueSentiment.POSITIVE)).tooltip(LTXIBootstrapUtil.energyUsageTooltip(fabUsage, ValueFormat.MULTIPLICATIVE, ValueSentiment.POSITIVE)).setMaxRank(4).effectIcon(UpgradeIcon.sprite("fabricator_upgrade")).register(context);
        MachineUpgrade.builder(TURRET_LOOTING).supports(blockEntities, LTXITags.BlockEntities.TURRETS).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(Enchantments.LOOTING))).setMaxRank(3).effectIcon(LTXIBootstrapUtil.luckOverlayIcon(LTXIItems.LTX_SWORD)).category("turret").register(context);
        MachineUpgrade.builder(TURRET_RAZOR).supports(blockEntities, LTXITags.BlockEntities.TURRETS).setMaxRank(2).withEffect(LTXIUpgradeEffectComponents.ENCHANTMENT_LEVELS, EnchantmentLevelsUpgradeEffect.rankLinear((Holder<Enchantment>)enchantments.getOrThrow(LTXIEnchantments.RAZOR))).effectIcon(UpgradeIcon.sprite("razor")).category("turret").register(context);
        MachineUpgrade.builder(TURRET_LOOT_COLLECTOR).supports(blockEntities, LTXITags.BlockEntities.TURRETS).withEffect(LTXIUpgradeEffectComponents.DIRECT_DROPS, DirectDropsUpgradeEffect.entityDrops((HolderSet<Item>)anyItemHolderSet)).effectIcon(UpgradeIcon.sprite("magnet")).category("turret").register(context);
    }
}

